
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000032=
{ /*reference*/     "lcrzoex", 32,
  /*version*/       1, 0,
  /*title*/         "{ETH,IP} spoof specified by user",
  /*french title*/  "spoof {ETH,IP} specifie par l'utilisateur",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "",
  /*french usage*/  "",
  /*usage example*/ "",
  /*fr. usage ex.*/ "", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000032_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000032_main(int argc, char *argv[])
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_spoof spoof;
  int language;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlip hdrlip;
  lcrzo_ipopt ipopt;
  lcrzo_uint8 ipoptsize;
  lcrzo_device device;

  /* get language */
  lcrzo_epr(lcrzo_global_get_language(&language));

  /* initialize device */
  lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1,
                                   device));
  lcrzo_epr(lcrzo_device_stdin((language==LCRZO_GLOBAL_FRLANG)?
                               "envoyer sur quel device":
                               "send on which device",
                               device, device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_stdin((language==LCRZO_GLOBAL_FRLANG)?"adresse source":
                             "source address", "aa:bb:cc:dd:ee:ff", 
                             hdrleth.src));
  lcrzo_epr(lcrzo_etha_stdin((language==LCRZO_GLOBAL_FRLANG)?
                             "adresse destination":"destination address",
                             "ff:ff:ff:ff:ff:ff", 
                             hdrleth.dst));

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_stdin((language==LCRZO_GLOBAL_FRLANG)?"adresse source":
			    "source address", "255.255.255.255",
			    &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_stdin((language==LCRZO_GLOBAL_FRLANG)?
			    "adresse destination":
			    "destination address", "1.2.3.4",
			    &(hdrlip.daddr)));
  lcrzo_epr(lcrzo_uint8_stdin((language==LCRZO_GLOBAL_FRLANG)?
			      "protocole":"protocol", 
			      0, 255, 0, &(hdrlip.protocol)));

  /* initialize IP options */
  lcrzo_epr(lcrzo_ipopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
			      "options IP":"IP options", "",
			      ipopt, &ipoptsize));

  /* initialize data */
  lcrzo_epr(lcrzo_data_initm_mixed_stdin((language==LCRZO_GLOBAL_FRLANG)?
					 "donnees du paquet":"packet's data",
					 "'hello' 0D0A", &data, &datasize));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ethipoptdata(&spoof, device, hdrleth,
				     hdrlip, ipopt, ipoptsize,
				     data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}
