
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000036=
{ /*reference*/     "lcrzoex", 36,
  /*version*/       1, 0,
  /*title*/         "spoof UDP packets saved in a record",
  /*french title*/  "spoofe les paquets UDP sauves dans record",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "file src_ip dst_ip [startpacket [endpacket]]",
  /*french usage*/  "nom_fichier ip_src ip_dst [packet_debut [packet_fin]]",
  /*usage example*/ "/tmp/file 1.2.3.4 5.6.7.8 1 6",
  /*fr. usage ex.*/ "/tmp/fichier 1.2.3.4 5.6.7.8 1 6", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000036_main(int argc, char *argv[]);
int lcrzoex_000036shared_spoofudpdata(lcrzo_constdata data,
				      lcrzo_int32 datasize,
				      const void *pinfos);
/*-------------------------------------------------------------*/
/* variable declaration */
lcrzo_ipl lcrzoex_000036iplsrc, lcrzoex_000036ipldst;

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000036_main(int argc, char *argv[])
{ lcrzo_int32 start, end;
  lcrzo_record record;

  if ( argc<4 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000036, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &lcrzoex_000036iplsrc));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[3], &lcrzoex_000036ipldst));
  if (argc>=5) start=atol(argv[4]); else start=+1;
  if (argc>=6) end=atol(argv[5]); else end=-1;

  /* open the record */
  lcrzo_epr(lcrzo_record_open(&record, argv[1], LCRZO_RECORD_OPEN_READ));

  /* main loop */
  lcrzo_epr(lcrzo_record_loop_range(&record, start, end,
				    &lcrzoex_000036shared_spoofudpdata, NULL));

  /* end */
  lcrzo_epr(lcrzo_record_close(&record));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000036shared_spoofudpdata(lcrzo_constdata data,
				      lcrzo_int32 datasize,
				      const void *pinfos)
{ lcrzo_spoof spoof;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrludp hdrludp;
  lcrzo_data udpdata;
  lcrzo_uint16 udpdatasize;

  /* init the new packet */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  hdrlip.saddr=lcrzoex_000036iplsrc;
  hdrlip.daddr=lcrzoex_000036ipldst;

  /* decode it because we need to reset the checksum 
     (in case we change IP addresses) */
  lcrzo_epr(lcrzo_packet_decodem_udpdata(data, datasize,
					 &hdrludp, 
					 &udpdata, &udpdatasize));
  hdrludp.check=LCRZO_HDRLUDP_CHECK_DEFVAL;

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ipoptudpdata(&spoof, hdrlip, NULL, 0,
				     hdrludp, udpdata, udpdatasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));
  lcrzo_data_free(udpdata);
  return (LCRZO_ERR_OK);
}

