
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000037=
{ /*reference*/     "lcrzoex", 37,
  /*version*/       1, 1,
  /*title*/         "{IP,UDP} spoof specified by user",
  /*french title*/  "spoof {IP,UDP} specifie par l'utilisateur",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "",
  /*french usage*/  "",
  /*usage example*/ "",
  /*fr. usage ex.*/ "", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000037_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000037_main(int argc, char *argv[])
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_spoof spoof;
  int language;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrludp hdrludp;
  lcrzo_ipopt ipopt;
  lcrzo_uint8 ipoptsize;

  /* get language */
  lcrzo_epr(lcrzo_global_get_language(&language));

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_stdin((language==LCRZO_GLOBAL_FRLANG)?"adresse source":
			    "source address", "255.255.255.255",
			    &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_stdin((language==LCRZO_GLOBAL_FRLANG)?
			    "adresse destination":
			    "destination address", "1.2.3.4",
			    &(hdrlip.daddr)));

  /* initialize IP options */
  lcrzo_epr(lcrzo_ipopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
			      "options IP":"IP options", "",
			      ipopt, &ipoptsize));

  /* initialize UDP header */
  lcrzo_epr(lcrzo_hdrludp_initdefault(&hdrludp));
  lcrzo_epr(lcrzo_uint16_stdin((language==LCRZO_GLOBAL_FRLANG)?
			       "port source":"source port", 0, 0xffff, 2345, 
			       &(hdrludp.sport)));
  lcrzo_epr(lcrzo_uint16_stdin((language==LCRZO_GLOBAL_FRLANG)?
			       "port destination":"destination port",
			       0, 0xffff, 53,
			       &(hdrludp.dport)));

  /* initialize data */
  lcrzo_epr(lcrzo_data_initm_mixed_stdin((language==LCRZO_GLOBAL_FRLANG)?
					 "donnees du paquet":"packet's data",
					 "'hello' 0D0A", &data, &datasize));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ipoptudpdata(&spoof, hdrlip, ipopt, ipoptsize,
				     hdrludp, data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}
