
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000039=
{ /*reference*/     "lcrzoex", 39,
  /*version*/       1, 0,
  /*title*/         "{IP,UDP} spoof specified by command line (constant data)",
  /*french title*/  "spoof {IP,UDP} specifie sur la ligne de commande (donnees constantes)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "ip_source_address ip_dest_address source_port dest_port",
  /*french usage*/  "adresse_ip_source adresse_ip_dest port_source port_dest",
  /*usage example*/ "1.2.3.4 5.6.7.8 1234 21",
  /*fr. usage ex.*/ "1.2.3.4 5.6.7.8 1234 21", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000039_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000039_main(int argc, char *argv[])
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_spoof spoof;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrludp hdrludp;
  lcrzo_ipopt ipopt;
  lcrzo_uint8 ipoptsize;

  if ( argc<5 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000039, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &(hdrlip.daddr)));

  /* initialize IP options */
  lcrzo_epr(lcrzo_ipopt_init_mixed("01 01 01 01", ipopt, &ipoptsize));

  /* initialize UDP header */
  lcrzo_epr(lcrzo_hdrludp_initdefault(&hdrludp));
  hdrludp.sport=(lcrzo_uint16)atoi(argv[3]);
  hdrludp.dport=(lcrzo_uint16)atoi(argv[4]);

  /* initialize data */
  lcrzo_epr(lcrzo_data_initm_mixed("'hello' 0D0A", &data, &datasize));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ipoptudpdata(&spoof, hdrlip, ipopt, ipoptsize,
				     hdrludp, data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}
