
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000046=
{ /*reference*/     "lcrzoex", 46,
  /*version*/       1, 0,
  /*title*/         "print TCP packets saved in a record",
  /*french title*/  "affiche les paquets TCP sauves dans record",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "file [startpacket [endpacket]]",
  /*french usage*/  "nom_fichier [packet_debut [packet_fin]]",
  /*usage example*/ "/tmp/file 1 6",
  /*fr. usage ex.*/ "/tmp/fichier 1 6", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000046_main(int argc, char *argv[]);
int lcrzoex_000046shared_printtcpdata(lcrzo_constdata data,
				      lcrzo_int32 datasize,
				      const void *pinfos);

/*-------------------------------------------------------------*/
/* variable declaration */
lcrzo_printprofile lcrzoex_000046printprofile;

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000046_main(int argc, char *argv[])
{ lcrzo_int32 start, end;
  lcrzo_record record;
  int language;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000046, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  if (argc>=3) start=atol(argv[2]); else start=+1;
  if (argc>=4) end=atol(argv[3]); else end=-1;

  /* open the record */
  lcrzo_epr(lcrzo_record_open(&record, argv[1], LCRZO_RECORD_OPEN_READ));

  /* get printprofile */
  lcrzo_epr(lcrzo_global_get_language(&language));
  lcrzo_epr(lcrzo_printprofile_stdin((language==LCRZO_GLOBAL_FRLANG)?
				     "Choisissez le profil d'affichage":
				     "Choose the print profile",
				     LCRZO_PRINTPROFILE_ARRAYDUMP, 
				     &lcrzoex_000046printprofile));

  /* main loop */
  lcrzo_epr(lcrzo_record_loop_range(&record, start, end,
				    &lcrzoex_000046shared_printtcpdata, NULL));

  /* end */
  lcrzo_epr(lcrzo_record_close(&record));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000046shared_printtcpdata(lcrzo_constdata data,
				      lcrzo_int32 datasize,
				      const void *pinfos)
{
  lcrzo_epr(lcrzo_packet_print_tcp(data, datasize,
				   lcrzoex_000046printprofile));
  if (lcrzoex_000046printprofile.hdr!=LCRZO_PRINTTYPE_SYNTH) printf("\n");
  return (LCRZO_ERR_OK);
}

