
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000049=
{ /*reference*/     "lcrzoex", 49,
  /*version*/       1, 1,
  /*title*/         "{IP,TCP} spoof specified by command line",
  /*french title*/  "spoof {IP,TCP} specifie sur la ligne de commande",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "ip_source_address ip_dest_address source_port dest_port syn ack rst seqnum acknum",
  /*french usage*/  "adresse_ip_source adresse_ip_dest port_source port_dest syn ack rst seqnum acknum",
  /*usage example*/ "1.2.3.4 5.6.7.8 1234 21 1 1 0 43223 493484",
  /*fr. usage ex.*/ "1.2.3.4 5.6.7.8 1234 21 1 1 0 43223 493484", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000049_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000049_main(int argc, char *argv[])
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_spoof spoof;
  int language;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrltcp hdrltcp;
  lcrzo_ipopt ipopt;
  lcrzo_tcpopt tcpopt;
  lcrzo_uint8 ipoptsize, tcpoptsize;

  if ( argc<10 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000049, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* get language */
  lcrzo_epr(lcrzo_global_get_language(&language));

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &(hdrlip.daddr)));

  /* initialize IP options */
  lcrzo_epr(lcrzo_ipopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
			      "options IP":"IP options", "",
			      ipopt, &ipoptsize));

  /* initialize TCP header */
  lcrzo_epr(lcrzo_hdrltcp_initdefault(&hdrltcp));
  hdrltcp.sport=(lcrzo_uint16)atoi(argv[3]);
  hdrltcp.dport=(lcrzo_uint16)atoi(argv[4]);
  hdrltcp.syn=(lcrzo_uint8)atoi(argv[5]);
  hdrltcp.ack=(lcrzo_uint8)atoi(argv[6]);
  hdrltcp.rst=(lcrzo_uint8)atoi(argv[7]);
  hdrltcp.seqnum=(lcrzo_uint32)atol(argv[8]);
  hdrltcp.acknum=(lcrzo_uint32)atol(argv[9]);

  /* initialize TCP options */
  lcrzo_epr(lcrzo_tcpopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
			       "options TCP":"TCP options", "",
			       tcpopt, &tcpoptsize));

  /* initialize data */
  lcrzo_epr(lcrzo_data_initm_mixed_stdin((language==LCRZO_GLOBAL_FRLANG)?
					 "donnees du paquet":"packet's data",
					 "'hello' 0D0A", &data, &datasize));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ipopttcpoptdata(&spoof, hdrlip, ipopt, ipoptsize,
					hdrltcp, tcpopt, tcpoptsize,
					data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}
