
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000051=
{ /*reference*/     "lcrzoex", 51,
  /*version*/       1, 2,
  /*title*/         "{ETH,IP,TCP} spoof specified by user",
  /*french title*/  "spoof {ETH,IP,TCP} specifie par l'utilisateur",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "",
  /*french usage*/  "",
  /*usage example*/ "",
  /*fr. usage ex.*/ "", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000051_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000051_main(int argc, char *argv[])
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_spoof spoof;
  int language;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrltcp hdrltcp;
  lcrzo_ipopt ipopt;
  lcrzo_tcpopt tcpopt;
  lcrzo_uint8 ipoptsize, tcpoptsize;
  lcrzo_device device;
  lcrzo_uint32 u32rand;

  /* get language */
  lcrzo_epr(lcrzo_global_get_language(&language));

  /* initialize device */
  lcrzo_epr(lcrzo_device_value_pos(LCRZO_DEVICE_TYPE_ONLYBOARDS, 1,
                                   device));
  lcrzo_epr(lcrzo_device_stdin((language==LCRZO_GLOBAL_FRLANG)?
                               "envoyer sur quel device":
                               "send on which device",
                               device, device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_stdin((language==LCRZO_GLOBAL_FRLANG)?"adresse source":
                             "source address", "aa:bb:cc:dd:ee:ff", 
                             hdrleth.src));
  lcrzo_epr(lcrzo_etha_stdin((language==LCRZO_GLOBAL_FRLANG)?
                             "adresse destination":"destination address",
                             "ff:ff:ff:ff:ff:ff", 
                             hdrleth.dst));

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_stdin((language==LCRZO_GLOBAL_FRLANG)?"adresse source":
			    "source address", "255.255.255.255",
			    &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_stdin((language==LCRZO_GLOBAL_FRLANG)?
			    "adresse destination":
			    "destination address", "1.2.3.4",
			    &(hdrlip.daddr)));

  /* initialize IP options */
  lcrzo_epr(lcrzo_ipopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
			      "options IP":"IP options", "",
			      ipopt, &ipoptsize));

  /* initialize TCP header */
  lcrzo_epr(lcrzo_hdrltcp_initdefault(&hdrltcp));
  lcrzo_epr(lcrzo_uint16_stdin((language==LCRZO_GLOBAL_FRLANG)?
			       "port source":"source port", 0, 0xffff, 2345, 
			       &(hdrltcp.sport)));
  lcrzo_epr(lcrzo_uint16_stdin((language==LCRZO_GLOBAL_FRLANG)?
			       "port destination":"destination port",
			       0, 0xffff, 53,
			       &(hdrltcp.dport)));
  lcrzo_epr(lcrzo_uint8_stdin("bit syn", 0,1, 0, &(hdrltcp.syn)));  
  lcrzo_epr(lcrzo_uint8_stdin("bit ack", 0,1, 0, &(hdrltcp.ack))); 
  lcrzo_epr(lcrzo_uint8_stdin("bit rst", 0,1, 0, &(hdrltcp.rst)));
  lcrzo_epr(lcrzo_uint32_rand(0, 0xFFFFFFFFu, &u32rand));
  lcrzo_epr(lcrzo_uint32_stdin("seqnum", 0, 0xFFFFFFFFu, u32rand,
			       &(hdrltcp.seqnum)));
  lcrzo_epr(lcrzo_uint32_rand(0, 0xFFFFFFFFu, &u32rand));
  lcrzo_epr(lcrzo_uint32_stdin("acknum", 0, 0xFFFFFFFFu, u32rand,
			       &(hdrltcp.acknum)));

  /* initialize TCP options */
  lcrzo_epr(lcrzo_tcpopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
			       "options TCP":"TCP options", "",
			       tcpopt, &tcpoptsize));

  /* initialize data */
  lcrzo_epr(lcrzo_data_initm_mixed_stdin((language==LCRZO_GLOBAL_FRLANG)?
					 "donnees du paquet":"packet's data",
					 "'hello' 0D0A", &data, &datasize));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ethipopttcpoptdata(&spoof, device, hdrleth,
					   hdrlip, ipopt, ipoptsize,
					   hdrltcp, tcpopt, tcpoptsize,
					   data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}
