
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000057=
{ /*reference*/     "lcrzoex", 57,
  /*version*/       1, 0,
  /*title*/         "{IP,TCP} spoof of a ACK",
  /*french title*/  "spoof {IP,TCP} d'un ACK",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "ip_source_address ip_dest_address source_port dest_port seqnum acknum",
  /*french usage*/  "adresse_ip_source adresse_ip_dest port_source port_dest num_seq num_ack",
  /*usage example*/ "1.2.3.4 5.6.7.8 1234 21 786453 56544",
  /*fr. usage ex.*/ "1.2.3.4 5.6.7.8 1234 21 786453 56544", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000057_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000057_main(int argc, char *argv[])
{ lcrzo_spoof spoof;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrltcp hdrltcp;

  if ( argc<7 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000057, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &(hdrlip.daddr)));

  /* initialize TCP header */
  lcrzo_epr(lcrzo_hdrltcp_initdefault(&hdrltcp));
  hdrltcp.sport=(lcrzo_uint16)atoi(argv[3]);
  hdrltcp.dport=(lcrzo_uint16)atoi(argv[4]);
  hdrltcp.ack=1;
  hdrltcp.seqnum=(lcrzo_uint32)atol(argv[5]);
  hdrltcp.acknum=(lcrzo_uint32)atol(argv[6]);

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ipopttcpoptdata(&spoof, hdrlip, NULL, 0,
					hdrltcp, NULL, 0, NULL, 0));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  return(LCRZO_ERR_OK);
}
