
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000059=
{ /*reference*/     "lcrzoex", 59,
  /*version*/       1, 0,
  /*title*/         "{IP,TCP} spoof of a ACK (source routing)",
  /*french title*/  "spoof {IP,TCP} d'un ACK (source routing)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "ip_source_address ip_dest_address source_port dest_port seqnum acknum router",
  /*french usage*/  "adresse_ip_source adresse_ip_dest port_source port_dest numseq numack routeur",
  /*usage example*/ "1.2.3.4 5.6.7.8 1234 21 786453 56544 1.2.3.5",
  /*fr. usage ex.*/ "1.2.3.4 5.6.7.8 1234 21 786453 56544 1.2.3.5", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000059_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000059_main(int argc, char *argv[])
{ lcrzo_spoof spoof;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrltcp hdrltcp;
  lcrzo_ipopt ipopt;
  lcrzo_uint8 ipoptsize;
  lcrzo_ipl ipldest, iplnull;

  if ( argc<8 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000059, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[7], &(hdrlip.daddr)));

  /* initialize IP options */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &ipldest));
  lcrzo_epr(lcrzo_ipl_initdefault(&iplnull));
  lcrzo_epr(lcrzo_ipopt_init_ssrr(ipldest, iplnull, iplnull, iplnull, iplnull,
                                  iplnull, iplnull, iplnull, iplnull,
                                  1, ipopt, &ipoptsize));

  /* initialize TCP header */
  lcrzo_epr(lcrzo_hdrltcp_initdefault(&hdrltcp));
  hdrltcp.sport=(lcrzo_uint16)atoi(argv[3]);
  hdrltcp.dport=(lcrzo_uint16)atoi(argv[4]);
  hdrltcp.ack=1;
  hdrltcp.seqnum=(lcrzo_uint32)atol(argv[5]);
  hdrltcp.acknum=(lcrzo_uint32)atol(argv[6]);

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ipopttcpoptdata(&spoof, hdrlip, ipopt, ipoptsize,
					hdrltcp, NULL, 0, NULL, 0));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  return(LCRZO_ERR_OK);
}
