
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000070=
{ /*reference*/     "lcrzoex", 70,
  /*version*/       1, 0,
  /*title*/         "{ETH,IP,ICMP} spoof specified by command line (constant data)",
  /*french title*/  "spoof {ETH,IP,ICMP} specifie sur la ligne de commande (donnees constantes)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device src_eth dst_eth src_ip dst_ip type code",
  /*french usage*/  "device eth_src eth_dst ip_src ip_dst type code",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 5.6.7.8 8 0",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 5.6.7.8 8 0", 
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000070_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000070_main(int argc, char *argv[])
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_spoof spoof;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrlicmp hdrlicmp;
  lcrzo_ipopt ipopt;
  lcrzo_uint8 ipoptsize;
  lcrzo_device device;

  if ( argc<8 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000070, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], hdrleth.src));
  lcrzo_epr(lcrzo_etha_init_eths(argv[3], hdrleth.dst));

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[4], &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[5], &(hdrlip.daddr)));

  /* initialize IP options */
  lcrzo_epr(lcrzo_ipopt_init_mixed("01 01 01 01", ipopt, &ipoptsize));

  /* initialize ICMP header */
  lcrzo_epr(lcrzo_hdrlicmp_initdefault(&hdrlicmp));
  hdrlicmp.type=(lcrzo_uint8)atoi(argv[6]);
  hdrlicmp.code=(lcrzo_uint8)atoi(argv[7]);

  /* initialize data */
  lcrzo_epr(lcrzo_data_initm_mixed("'hello' 0D0A", &data, &datasize));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_ethipopticmpdata(&spoof, device, hdrleth,
					 hdrlip, ipopt, ipoptsize,
					 hdrlicmp, data, datasize));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}
