
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000080=
{ /*reference*/     "lcrzoex", 80,
  /*version*/       1, 0,
  /*title*/         "{ETH,ARP} spoof of an ARP request",
  /*french title*/  "spoof {ETH,ARP} d'une requete ARP",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device ip_asker eth_asker ip_wanted [eth_to_which_ask]",
  /*french usage*/  "device ip_demandeur eth_demandeur ip_voulue [eth_a_qui_demande]",
  /*usage example*/ "eth0 1.2.3.4 aa:bb:cc:dd:ee:ff 1.2.3.5",
  /*fr. usage ex.*/ "eth0 1.2.3.4 aa:bb:cc:dd:ee:ff 1.2.3.5",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000080_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000080_main(int argc, char *argv[])
{ lcrzo_spoof spoof;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlarp hdrlarp;
  lcrzo_device device;

  if ( argc<5 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000080, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_init_eths(argv[3], hdrleth.src));
  if (argc==6)
  { lcrzo_epr(lcrzo_etha_init_eths(argv[5], hdrleth.dst));
  }
  else
  { lcrzo_epr(lcrzo_etha_init(0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			      hdrleth.dst));
  }
  hdrleth.type=LCRZO_HDRLETH_TYPE_ARP;

  /* initialize ARP header */
  lcrzo_epr(lcrzo_hdrlarp_initdefault(&hdrlarp));
  hdrlarp.op = 1;
  memcpy(hdrlarp.hw_src, hdrleth.src, LCRZO_ETHA_MAXBYTES);
  lcrzo_epr(lcrzo_ipa_init_hs(argv[2], hdrlarp.prot_src));
  lcrzo_epr(lcrzo_etha_init(0,0,0,0,0,0, hdrlarp.hw_dst));
  lcrzo_epr(lcrzo_ipa_init_hs(argv[4], hdrlarp.prot_dst));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_etharp(&spoof, device, hdrleth, hdrlarp));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  return(LCRZO_ERR_OK);
}
