
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000082=
{ /*reference*/     "lcrzoex", 82,
  /*version*/       1, 0,
  /*title*/         "{ETH,ARP} spoof of a RARP request",
  /*french title*/  "spoof {ETH,ARP} d'une requete RARP",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device eth_asker eth_wanted",
  /*french usage*/  "device eth_demandeur eth_voulue",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000082_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000082_main(int argc, char *argv[])
{ lcrzo_spoof spoof;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlarp hdrlarp;
  lcrzo_device device;

  if ( argc<4 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000082, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], hdrleth.src));
  lcrzo_epr(lcrzo_etha_init_eths(argv[3], hdrleth.dst));
  hdrleth.type=LCRZO_HDRLETH_TYPE_RARP;

  /* initialize ARP header */
  lcrzo_epr(lcrzo_hdrlarp_initdefault(&hdrlarp));
  hdrlarp.op = 3;
  memcpy(hdrlarp.hw_src, hdrleth.src, LCRZO_ETHA_MAXBYTES);
  lcrzo_epr(lcrzo_ipa_init(0,0,0,0, hdrlarp.prot_src)); /*rfc 903*/
  memcpy(hdrlarp.hw_dst, hdrleth.dst, LCRZO_ETHA_MAXBYTES);
  lcrzo_epr(lcrzo_ipa_init(0,0,0,0, hdrlarp.prot_dst));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_etharp(&spoof, device, hdrleth, hdrlarp));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  return(LCRZO_ERR_OK);
}
