
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000083=
{ /*reference*/     "lcrzoex", 83,
  /*version*/       1, 0,
  /*title*/         "{ETH,ARP} spoof of a RARP reply",
  /*french title*/  "spoof {ETH,ARP} d'une reponse RARP",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device eth_asked ip_answer [eth_asker [eth_answerer ip_answerer]",
  /*french usage*/  "device eth_demandee ip_reponse [eth_demandeur [eth_repondeur ip_repondeur]]",
  /*usage example*/ "eth0 11:22:33:44:55:66 1.2.3.4 aa:bb:cc:dd:ee:ff",
  /*fr. usage ex.*/ "eth0 11:22:33:44:55:66 1.2.3.4 aa:bb:cc:dd:ee:ff",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000083_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000083_main(int argc, char *argv[])
{ lcrzo_spoof spoof;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlarp hdrlarp;
  lcrzo_device device;

  if ( argc<4 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000083, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], hdrleth.src));
  if (argc>=5)
  { lcrzo_epr(lcrzo_etha_init_eths(argv[4], hdrleth.dst));
  }
  else
  { lcrzo_epr(lcrzo_etha_init(0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
			      hdrleth.dst));
  }
  hdrleth.type=LCRZO_HDRLETH_TYPE_RARP;

  /* initialize ARP header */
  lcrzo_epr(lcrzo_hdrlarp_initdefault(&hdrlarp));
  hdrlarp.op = 4;
  if (argc==7)
  { lcrzo_epr(lcrzo_etha_init_eths(argv[5], hdrlarp.hw_src));
    lcrzo_epr(lcrzo_ipa_init_hs(argv[6], hdrlarp.prot_src));
  }
  else
  { memcpy(hdrlarp.hw_src, hdrleth.src, LCRZO_ETHA_MAXBYTES);
    lcrzo_epr(lcrzo_ipa_init_hs(argv[3], hdrlarp.prot_src));
  }
  memcpy(hdrlarp.hw_dst, hdrleth.src, LCRZO_ETHA_MAXBYTES);
  lcrzo_epr(lcrzo_ipa_init_hs(argv[3], hdrlarp.prot_dst));

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_etharp(&spoof, device, hdrleth, hdrlarp));
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  return(LCRZO_ERR_OK);
}
