
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000088=
{ /*reference*/     "lcrzoex", 88,
  /*version*/       1, 0,
  /*title*/         "real udp client [syslog]",
  /*french title*/  "client udp reel [syslog]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port",
  /*french usage*/  "nom_serveur port_serveur",
  /*usage example*/ "1.2.3.5 4444",
  /*fr. usage ex.*/ "1.2.3.5 4444",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000088_main(int argc, char *argv[]);
int lcrzoex_000088_syslog(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000088_main(int argc, char *argv[])
{ lcrzo_ipl ipl;
  lcrzo_sock sock;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000088, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &ipl));
  lcrzo_epr(lcrzo_sock_udpcli_real(ipl, (lcrzo_uint16)atoi(argv[2]), &sock));
  lcrzo_epr(lcrzoex_000088_syslog(sock));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000088_syslog(lcrzo_sock sock)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_time currenttime;

  /* initialize the data */
  lcrzo_epr(lcrzo_data_initm_text("<17>Laurent was ", &data, &datasize));
  lcrzo_epr(lcrzo_time_init(&currenttime));
  lcrzo_epr(lcrzo_data_appendm_text("here at ", datasize, 
                                    &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_int(currenttime.sec, "%08X", datasize, 
                                   &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(".", datasize, 
                                    &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_int(currenttime.usec, "%08X", datasize, 
                                   &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(".", datasize, &data, &datasize));

  /* write this data */
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);

  /* close the socket (cannot be used anymore) */
  lcrzo_epr(lcrzo_sock_close(sock));

  return (LCRZO_ERR_OK);
}
