
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000100=
{ /*reference*/     "lcrzoex", 100,
  /*version*/       1, 0,
  /*title*/         "real tcp client [banner]",
  /*french title*/  "client tcp reel [banniere]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port",
  /*french usage*/  "nom_serveur port_serveur",
  /*usage example*/ "1.2.3.4 5555",
  /*fr. usage ex.*/ "1.2.3.4 5555",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000100_main(int argc, char *argv[]);
int lcrzoex_000100_banner(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000100_main(int argc, char *argv[])
{ lcrzo_ipl ipl;
  lcrzo_sock sock;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000100, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &ipl));
  lcrzo_epr(lcrzo_sock_tcpcli_real(ipl, (lcrzo_uint16)atoi(argv[2]), &sock));
  lcrzo_epr(lcrzoex_000100_banner(sock));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000100_banner(lcrzo_sock sock)
{ lcrzo_data data;
  lcrzo_int32 datasize;
 
  /* first, we read the banner */
  lcrzo_epr(lcrzo_sock_readm(&sock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'quit' */
  lcrzo_epr(lcrzo_data_initm_text("QUIT\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);

  /* close the socket */
  lcrzo_epr(lcrzo_sock_close(sock));
  return (LCRZO_ERR_OK);
}
