
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000101=
{ /*reference*/     "lcrzoex", 101,
  /*version*/       1, 0,
  /*title*/         "real tcp client [banner] (local ip/port and IP option)",
  /*french title*/  "client tcp reel [banniere] (ip/port local et option IP)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "client_name server_name client_port server_port",
  /*french usage*/  "nom_client nom_serveur port_client port_serveur",
  /*usage example*/ "1.2.3.4 1.2.3.5 6666 21",
  /*fr. usage ex.*/ "1.2.3.4 1.2.3.5 6666 21",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000101_main(int argc, char *argv[]);
int lcrzoex_000100_banner(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000101_main(int argc, char *argv[])
{ lcrzo_ipl serveripl, clientipl;
  lcrzo_uint16 serverport, clientport;
  lcrzo_sock sock;
  lcrzo_ipopt ipopt;
  lcrzo_int8 ipoptsize;
  int language;

  if ( argc<5 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000101, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &clientipl));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &serveripl));

  /* initialize IP options */
  lcrzo_global_get_language(&language);
  lcrzo_epr(lcrzo_ipopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
                              "options IP":"IP options", "",
                              ipopt, &ipoptsize));

  /* initialize port numbers */
  clientport=(lcrzo_uint16)atoi(argv[3]);
  serverport=(lcrzo_uint16)atoi(argv[4]);

  /* initialize the socket */
  lcrzo_epr(lcrzo_sock_tcpcli_real2(clientipl, serveripl,
				    clientport, serverport,
				    ipopt, ipoptsize,
				    &sock));
  
  /* call the example working on the socket */
  lcrzo_epr(lcrzoex_000100_banner(sock));

  return(LCRZO_ERR_OK);
}
