
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000104=
{ /*reference*/     "lcrzoex", 104,
  /*version*/       1, 0,
  /*title*/         "real tcp client [active ftp]",
  /*french title*/  "client tcp reel [ftp actif]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "cliname sername cliport serport clidataport file",
  /*french usage*/  "nomcli nomserv portcli portserv portdonneescli fichier",
  /*usage example*/ "1.2.3.4 1.2.3.5 6666 21 7777 /etc/hosts",
  /*fr. usage ex.*/ "1.2.3.4 1.2.3.5 6666 21 7777 /etc/hosts",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000104_main(int argc, char *argv[]);
void lcrzoex_000104_actiftp_data(lcrzo_sock *psock);
int lcrzoex_000104_actiftp_cont(lcrzo_sock sock,
				lcrzo_ipl clientipl, 
				lcrzo_uint16 clientdataport,
				char *file);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000104_main(int argc, char *argv[])
{ lcrzo_ipl clientipl, serveripl;
  lcrzo_uint16 clientport, serverport, clientdataport;
  lcrzo_sock controlsock, datasock;
  int pid, ret, status;

  if ( argc<7 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000104, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &clientipl));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &serveripl));

  /* initialize ports */
  clientport=(lcrzo_uint16)atoi(argv[3]);
  serverport=(lcrzo_uint16)atoi(argv[4]);
  clientdataport=(lcrzo_uint16)atoi(argv[5]);

  /* initialize data connection, and listen (in a child process) */
  pid=fork();
  if (pid<0) return(LCRZO_ERR_FUFORK);
  if (pid==0)
  { ret=lcrzo_sock_tcpser_real2(clientipl, clientdataport, NULL, 0,
				&datasock);
    if ( ret!=LCRZO_ERR_OK ) { lcrzo_err_print(ret); _exit(ret); }
    lcrzoex_000104_actiftp_data(&datasock);
    /* never reatched */
  }

  /* initialize control connection, and send control commands */
  lcrzo_epr(lcrzo_sock_tcpcli_real2(clientipl, serveripl,
				    clientport, serverport, 
				    NULL, 0, &controlsock));
  lcrzo_epr(lcrzoex_000104_actiftp_cont(controlsock,
					clientipl, clientdataport,
					argv[6]));

  /* kill the child */
  ret=kill(pid, SIGINT);
  if (ret==-1) return(LCRZO_ERR_FUKILL);
  ret=waitpid(pid, &status, 0);
  if (ret==-1) return(LCRZO_ERR_FUWAITPID);

  return (LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000104_sig_received(int i);
lcrzo_sock lcrzoex_000104_sock;
void lcrzoex_000104_actiftp_data(lcrzo_sock *psock)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  int ret;

  /* prepare for Control-C */
  signal(SIGINT, lcrzoex_000104_sig_received);
  lcrzoex_000104_sock=*psock;

  while(1)
  { ret=lcrzo_sock_readm(&lcrzoex_000104_sock, LCRZO_TRUE, &data, &datasize);
    if ( ret!=LCRZO_ERR_OK )
    { lcrzo_err_print(ret);
      _exit(ret);
    }
    lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_TEXT);
    lcrzo_data_free(data);
  }
  /* never reatched */
}
void lcrzoex_000104_sig_received(int i)
{ lcrzo_sock_close(lcrzoex_000104_sock);
  raise(SIGTERM);
}

/*-------------------------------------------------------------*/
int lcrzoex_000104_actiftp_cont(lcrzo_sock sock,
				lcrzo_ipl clientipl, 
				lcrzo_uint16 clientdataport,
				char *file)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_ipa clientipa; 

  /* first, we read the banner */
  lcrzo_epr(lcrzo_sock_readm(&sock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'USER' */
  sleep(1);
  lcrzo_epr(lcrzo_data_initm_text("USER anonymous\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(&sock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'PASS' */
  sleep(1);
  lcrzo_epr(lcrzo_data_initm_text("PASS toto@dom.ex\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(&sock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'PORT' */
  sleep(1);
  lcrzo_epr(lcrzo_ipa_init_ipl(clientipl, clientipa));
  lcrzo_epr(lcrzo_data_initm_text("PORT ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_int(clientipa[0], "%d", datasize,
				   &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_char(',', 1, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_int(clientipa[1], "%d", datasize,
				   &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_char(',', 1, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_int(clientipa[2], "%d", datasize,
				   &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_char(',', 1, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_int(clientipa[3], "%d", datasize,
				   &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_char(',', 1, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_int(clientdataport>>8, "%d", datasize,
				   &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_char(',', 1, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_int(clientdataport&0xFF, "%d", datasize,
				   &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(&sock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'RETR' */
  sleep(1);
  lcrzo_epr(lcrzo_data_initm_text("RETR ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(file, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(&sock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'QUIT' */
  sleep(5);
  lcrzo_epr(lcrzo_data_initm_text("QUIT\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(&sock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* close the socket */
  lcrzo_epr(lcrzo_sock_close(sock));
  return (LCRZO_ERR_OK);
}
