
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000106=
{ /*reference*/     "lcrzoex", 106,
  /*version*/       1, 0,
  /*title*/         "real tcp client [passive ftp]",
  /*french title*/  "client tcp reel [ftp passif]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "cliname sername cliport serport clidataport file",
  /*french usage*/  "nomcli nomserv portcli portserv portdonneescli fichier",
  /*usage example*/ "1.2.3.4 1.2.3.5 6666 21 7777 /etc/hosts",
  /*fr. usage ex.*/ "1.2.3.4 1.2.3.5 6666 21 7777 /etc/hosts",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000106_main(int argc, char *argv[]);
int lcrzoex_000106_passftp_contbegin(lcrzo_sock *psock,
				     lcrzo_ipl *pserveripl, 
				     lcrzo_uint16 *pserverdataport);
void lcrzoex_000106_passftp_data(lcrzo_sock *psock);
int lcrzoex_000106_passftp_contend(lcrzo_sock *psock,
				   char *file);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000106_main(int argc, char *argv[])
{ lcrzo_ipl clientipl, serveripl;
  lcrzo_uint16 clientport, serverport, clientdataport, serverdataport;
  lcrzo_sock controlsock, datasock;
  int pid, ret, status;

  if ( argc<7 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000106, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &clientipl));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &serveripl));

  /* initialize ports */
  clientport=(lcrzo_uint16)atoi(argv[3]);
  serverport=(lcrzo_uint16)atoi(argv[4]);
  clientdataport=(lcrzo_uint16)atoi(argv[5]);

  /* initialize control connection */
  lcrzo_epr(lcrzo_sock_tcpcli_real2(clientipl, serveripl,
				    clientport, serverport, 
				    NULL, 0, &controlsock));

  /* obtains server data port */
  lcrzo_epr(lcrzoex_000106_passftp_contbegin(&controlsock,
					     &serveripl,
					     &serverdataport));
  lcrzo_ipl_print("Server IP : ", serveripl, "\n");
  printf("Server port : %d\n", serverdataport);

  /* initialize data connection, and listen (in a child process) */
  pid=fork();
  if (pid<0) return(LCRZO_ERR_FUFORK);
  if (pid==0)
  { ret=lcrzo_sock_tcpcli_real2(clientipl, serveripl, 
				clientdataport, serverdataport, NULL, 0,
				&datasock);
    if ( ret!=LCRZO_ERR_OK ) { lcrzo_err_print(ret); _exit(ret); }
    lcrzoex_000106_passftp_data(&datasock);
    /* never reatched */
  }

  /* requests the file */
  lcrzo_epr(lcrzoex_000106_passftp_contend(&controlsock, argv[6]));

  /* kill the child */
  ret=kill(pid, SIGINT);
  if (ret==-1) return(LCRZO_ERR_FUKILL);
  ret=waitpid(pid, &status, 0);
  if (ret==-1) return(LCRZO_ERR_FUWAITPID);

  return (LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000106_passftp_contbegin(lcrzo_sock *psock,
				     lcrzo_ipl *pserveripl, 
				     lcrzo_uint16 *pserverdataport)
{ lcrzo_data data;
  lcrzo_string string;
  lcrzo_int32 datasize;
  lcrzo_regexp re;
  lcrzo_uint8 portvalues[6];
  int i;

  /* first, we read the banner */
  lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'USER' */
  sleep(1);
  lcrzo_epr(lcrzo_data_initm_text("USER anonymous\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'PASS' */
  sleep(1);
  lcrzo_epr(lcrzo_data_initm_text("PASS toto@dom.ex\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'PASV' */
  sleep(1);
  lcrzo_epr(lcrzo_data_initm_text("PASV\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_epr(lcrzo_data_search_regexp(data, datasize, LCRZO_FALSE, +1, -1,
				     "227 Entering Passive Mode \\("
				     "([0-9]+),([0-9]+),([0-9]+),"
				     "([0-9]+),([0-9]+),([0-9]+)\\)", re));
  data[datasize]='\0';
  for ( i=0 ; i<6 ; i++ )
  { lcrzo_epr(lcrzo_string_initm_range(data, re[i+1].startindex_positive,
				       re[i+1].endindex_positive, &string));
    portvalues[i]=(lcrzo_uint8)atoi(string);
    lcrzo_string_free(string);
  }
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_ipl_init_ipa(portvalues, pserveripl));
  *pserverdataport=(lcrzo_uint16)((portvalues[4]<<8)|portvalues[5]);

  return (LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000106_sig_received(int i);
lcrzo_sock lcrzoex_000106_sock;
void lcrzoex_000106_passftp_data(lcrzo_sock *psock)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  int ret;

  /* prepare for Control-C */
  signal(SIGINT, lcrzoex_000106_sig_received);
  lcrzoex_000106_sock=*psock;

  while(1)
  { ret=lcrzo_sock_readm(&lcrzoex_000106_sock, LCRZO_TRUE, &data, &datasize);
    if ( ret!=LCRZO_ERR_OK )
    { lcrzo_err_print(ret);
      _exit(ret);
    }
    lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_TEXT);
    lcrzo_data_free(data);
  }
  /* never reatched */
}
void lcrzoex_000106_sig_received(int i)
{ lcrzo_sock_close(lcrzoex_000106_sock);
  raise(SIGTERM);
}

/*-------------------------------------------------------------*/
int lcrzoex_000106_passftp_contend(lcrzo_sock *psock,
				   char *file)
{ lcrzo_data data;
  lcrzo_int32 datasize;

  /* we send a 'RETR' */
  sleep(1);
  lcrzo_epr(lcrzo_data_initm_text("RETR ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(file, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* then, we send a 'QUIT' */
  sleep(5);
  lcrzo_epr(lcrzo_data_initm_text("QUIT\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
  lcrzo_data_free(data);

  /* close the socket */
  lcrzo_epr(lcrzo_sock_close(*psock));
  return (LCRZO_ERR_OK);
}
