
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000107=
{ /*reference*/     "lcrzoex", 107,
  /*version*/       1, 0,
  /*title*/         "virtual tcp client [passive ftp]",
  /*french title*/  "client tcp virtuel [ftp passif]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device clieth sereth cliname sername cliport serport clidataport file",
  /*french usage*/  "device ethcli ethserv nomcli nomserv portcli portserv portdonneescli fichier",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 1.2.3.5 6666 21 7777 /etc/hosts",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 1.2.3.5 6666 21 7777 /etc/hosts",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000107_main(int argc, char *argv[]);
int lcrzoex_000106_passftp_contbegin(lcrzo_sock *psock,
				     lcrzo_ipl *pserveripl, 
				     lcrzo_uint16 *pserverdataport);
void lcrzoex_000106_passftp_data(lcrzo_sock *psock);
int lcrzoex_000106_passftp_contend(lcrzo_sock *psock,
				   char *file);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000107_main(int argc, char *argv[])
{ lcrzo_device device;
  lcrzo_etha clienteth, servereth;
  lcrzo_ipl clientipl, serveripl;
  lcrzo_uint16 clientport, serverport, clientdataport, serverdataport;
  lcrzo_sock controlsock, datasock;
  int pid, ret, status;

  if ( argc<10 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000107, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* initialize Ethernet addresses */
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], clienteth));
  lcrzo_epr(lcrzo_etha_init_eths(argv[3], servereth));

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[4], &clientipl));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[5], &serveripl));

  /* initialize ports */
  clientport=(lcrzo_uint16)atoi(argv[6]);
  serverport=(lcrzo_uint16)atoi(argv[7]);
  clientdataport=(lcrzo_uint16)atoi(argv[8]);

  /* initialize control connection */
  lcrzo_epr(lcrzo_sock_tcpcli_virt(device, clienteth, servereth,
				   clientipl, serveripl,
				   clientport, serverport, 
				   &controlsock));

  /* obtains server data port */
  lcrzo_epr(lcrzoex_000106_passftp_contbegin(&controlsock,
					     &serveripl,
					     &serverdataport));
  lcrzo_ipl_print("Server IP : ", serveripl, "\n");
  printf("Server port : %d\n", serverdataport);

  /* initialize data connection, and listen (in a child process) */
  pid=fork();
  if (pid<0) return(LCRZO_ERR_FUFORK);
  if (pid==0)
  { ret=lcrzo_sock_tcpcli_virt(device, clienteth, servereth,
			       clientipl, serveripl, 
			       clientdataport, serverdataport,
			       &datasock);
    if ( ret!=LCRZO_ERR_OK ) { lcrzo_err_print(ret); _exit(ret); }
    lcrzoex_000106_passftp_data(&datasock);
    /* never reatched */
  }

  /* requests the file */
  lcrzo_epr(lcrzoex_000106_passftp_contend(&controlsock, argv[9]));

  /* kill the child */
  ret=kill(pid, SIGINT);
  if (ret==-1) return(LCRZO_ERR_FUKILL);
  ret=waitpid(pid, &status, 0);
  if (ret==-1) return(LCRZO_ERR_FUWAITPID);

  return (LCRZO_ERR_OK);
}

