
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000108=
{ /*reference*/     "lcrzoex", 108,
  /*version*/       1, 1,
  /*title*/         "real udp server [stdin]",
  /*french title*/  "serveur udp reel [stdin]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_port",
  /*french usage*/  "port_serveur",
  /*usage example*/ "5566",
  /*fr. usage ex.*/ "5566",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000108_main(int argc, char *argv[]);
int lcrzoex_000108_stdin_sock(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000108_main(int argc, char *argv[])
{ lcrzo_sock sock;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000108, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_sock_udpser_real((lcrzo_uint16)atoi(argv[1]), &sock));
  lcrzo_epr(lcrzoex_000108_stdin_sock(sock));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000108_sig_received(int i);
int lcrzoex_000108_pid;
lcrzo_sock lcrzoex_000108_sock;

int lcrzoex_000108_stdin_sock(lcrzo_sock sock)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  int ret, language;

  lcrzo_global_get_language(&language);

  /* in case we receive a signal */
  signal(SIGINT, lcrzoex_000108_sig_received);
  lcrzoex_000108_sock=sock;

  /* we cannot write before reading */
  if ( language==LCRZO_GLOBAL_FRLANG )
    puts("\nNous attendons que le client ecrive.");
  else
    puts("\nWe wait for the client to write.");
  ret=lcrzo_sock_readm(&lcrzoex_000108_sock, LCRZO_TRUE, &data, &datasize);
  
  lcrzoex_000108_pid=fork();
  if (lcrzoex_000108_pid<0) return(LCRZO_ERR_FUFORK);
  if (lcrzoex_000108_pid==0)
  { /* this process prints read data (child) */
    while(1)
    { if ( ret!=LCRZO_ERR_OK )
      { if ( language==LCRZO_GLOBAL_FRLANG )
	  puts("\nLa lecture sur la socket n'est plus possible.");
        else
	  puts("\nWe cannot read from the socket anymore.");
        kill(getppid(), SIGINT);
	_exit(ret);
      }
      if ( datasize!=0 )
      { printf("\n");
        lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP);
      }
      lcrzo_data_free(data);
      ret=lcrzo_sock_readm(&lcrzoex_000108_sock, LCRZO_TRUE, 
			   &data, &datasize);
    }
    /* never reatched */
  }
  else
  { /* this process writes data */
    while(1)
    { lcrzo_epr(lcrzo_data_initm_mixed_stdin((language==LCRZO_GLOBAL_FRLANG)?
					     "Vos donnees mixtes":
					     "Your mixed data",
					     "'hello' 0D0A", 
					     &data, &datasize));
      ret=lcrzo_sock_write(lcrzoex_000108_sock, data, datasize);
      lcrzo_data_free(data);
      if (ret!=LCRZO_ERR_OK)
      { if ( language==LCRZO_GLOBAL_FRLANG )
	  puts("\nL'ecriture sur la socket n'est plus possible.");
        else 
	  puts("\nWe cannot write to the socket anymore.");
        raise(SIGINT);
      }
    }
    /* never reatched */
  }
  /* never reatched */
  return (LCRZO_ERR_IEINTERNALERROR);
}

/*-------------------------------------------------------------*/
void lcrzoex_000108_sig_received(int i)
{ int status, language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture de la socket (recu : SIG%d)\n", i);
  else
    printf("Closing socket (received : SIG%d)\n", i);
  kill(lcrzoex_000108_pid, SIGTERM);
  waitpid(lcrzoex_000108_pid, &status, 0);
  lcrzo_sock_close(lcrzoex_000108_sock);
  raise(SIGTERM);
}
