
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000112=
{ /*reference*/     "lcrzoex", 112,
  /*version*/       1, 0,
  /*title*/         "real udp server [echo]",
  /*french title*/  "serveur udp reel [echo]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_port",
  /*french usage*/  "port_serveur",
  /*usage example*/ "5566",
  /*fr. usage ex.*/ "5566",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000112_main(int argc, char *argv[]);
int lcrzoex_000112_echo(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000112_main(int argc, char *argv[])
{ lcrzo_sock sock;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000112, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_sock_udpser_real((lcrzo_uint16)atoi(argv[1]), &sock));
  lcrzoex_000112_echo(sock);

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000112_sig_received(int i);
lcrzo_sock lcrzoex_000112_sock;

int lcrzoex_000112_echo(lcrzo_sock sock)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  int ret, language;

  lcrzo_global_get_language(&language);

  /* in case we receive a signal */
  signal(SIGINT, lcrzoex_000112_sig_received);
  lcrzoex_000112_sock=sock;

  while(1)
  { ret=lcrzo_sock_readm(&lcrzoex_000112_sock, LCRZO_TRUE, 
			 &data, &datasize);
    if ( ret!=LCRZO_ERR_OK )
    { if ( language==LCRZO_GLOBAL_FRLANG )
        puts("\nLa lecture sur la socket n'est plus possible.");
      else
	puts("\nWe cannot read from the socket anymore.");
      kill(getpid(), SIGINT);
    }
    if ( datasize!=0 )
    { if ( language==LCRZO_GLOBAL_FRLANG )
	puts("On vient de lire :");
      else
        puts("We read :");
      lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
      lcrzo_epr(lcrzo_sock_write(lcrzoex_000112_sock, data, datasize));
    }
    lcrzo_data_free(data);
  }
  /* never reatched */
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000112_sig_received(int i)
{ int language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture de la socket (recu : SIG%d)\n", i);
  else
    printf("Closing socket (received : SIG%d)\n", i);
  lcrzo_sock_close(lcrzoex_000112_sock);
  raise(SIGTERM);
}
