
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000117=
{ /*reference*/     "lcrzoex", 117,
  /*version*/       1, 0,
  /*title*/         "real tcp server [stdin] (local ip and IP option)",
  /*french title*/  "server tcp reel [stdin] (ip locale et option IP)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port",
  /*french usage*/  "nom_serveur port_serveur",
  /*usage example*/ "1.2.3.4 5566",
  /*fr. usage ex.*/ "1.2.3.4 5566",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000117_main(int argc, char *argv[]);
int lcrzoex_000084_stdin_sock(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000117_main(int argc, char *argv[])
{ lcrzo_ipl serveripl;
  lcrzo_uint16 serverport;
  lcrzo_sock sock;
  lcrzo_ipopt ipopt;
  lcrzo_int8 ipoptsize;
  int language;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000117, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &serveripl));

  /* initialize IP options */
  lcrzo_global_get_language(&language);
  lcrzo_epr(lcrzo_ipopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
                              "options IP":"IP options", "",
                              ipopt, &ipoptsize));

  /* initialize port numbers */
  serverport=(lcrzo_uint16)atoi(argv[2]);

  /* initialize the socket */
  lcrzo_epr(lcrzo_sock_tcpser_real2(serveripl, serverport,
				    ipopt, ipoptsize,
				    &sock));
  
  /* call the example working on the socket */
  lcrzo_epr(lcrzoex_000084_stdin_sock(sock));

  return(LCRZO_ERR_OK);
}
