
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000122=
{ /*reference*/     "lcrzoex", 122,
  /*version*/       1, 0,
  /*title*/         "virtual tcp server [echo]",
  /*french title*/  "serveur tcp virtuel [echo]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device serveth servname servport",
  /*french usage*/  "device ethserv nomserv portserv",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 1.2.3.4 5566",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 1.2.3.4 5566",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000122_main(int argc, char *argv[]);
int lcrzoex_000112_echo(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000122_main(int argc, char *argv[])
{ lcrzo_etha servereth;
  lcrzo_ipl serveripl;
  lcrzo_uint16 serverport;
  lcrzo_sock sock;

  if ( argc<5 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000122, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize Ethernet addresses */
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], servereth));

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[3], &serveripl));

  /* initialize port numbers */
  serverport=(lcrzo_uint16)atoi(argv[4]);

  /* initialize the socket */
  lcrzo_epr(lcrzo_sock_tcpser_virt(argv[1],
				   servereth, serveripl, serverport,
				   &sock));
 
  /* call the example working on the socket */
  lcrzo_epr(lcrzoex_000112_echo(sock));

  return(LCRZO_ERR_OK);
}
