
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000123=
{ /*reference*/     "lcrzoex", 123,
  /*version*/       1, 0,
  /*title*/         "virtual tcp server [echo] (IP option)",
  /*french title*/  "server tcp virtuel [echo] (option IP)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device serveth servname servport",
  /*french usage*/  "device ethserv nomserv portserv",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 1.2.3.4 5566",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 1.2.3.4 5566",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000123_main(int argc, char *argv[]);
int lcrzoex_000112_echo(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000123_main(int argc, char *argv[])
{ lcrzo_etha servereth;
  lcrzo_ipl serveripl;
  lcrzo_uint16 serverport;
  lcrzo_sock sock;
  lcrzo_ipopt ipopt;
  lcrzo_int8 ipoptsize;
  int language;

  if ( argc<5 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000123, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize Ethernet addresses */
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], servereth));

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[3], &serveripl));

  /* initialize IP options */
  lcrzo_global_get_language(&language);
  lcrzo_epr(lcrzo_ipopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
                              "options IP":"IP options", "",
                              ipopt, &ipoptsize));

  /* initialize port numbers */
  serverport=(lcrzo_uint16)atoi(argv[4]);

  /* initialize the socket */
  lcrzo_epr(lcrzo_sock_tcpser_virt2(argv[1],
				    servereth, serveripl, serverport,
				    ipopt, ipoptsize,
				    &sock));
 
  /* call the example working on the socket */
  lcrzo_epr(lcrzoex_000112_echo(sock));

  return(LCRZO_ERR_OK);
}
