
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000125=
{ /*reference*/     "lcrzoex", 125,
  /*version*/       1, 0,
  /*title*/         "real multiclient udp server [echo] (local ip)",
  /*french title*/  "server udp multiclient reel [echo] (ip locale)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port",
  /*french usage*/  "nom_serveur port_serveur",
  /*usage example*/ "1.2.3.4 5566",
  /*fr. usage ex.*/ "1.2.3.4 5566",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000125_main(int argc, char *argv[]);
int lcrzoex_000124_echo(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000125_main(int argc, char *argv[])
{ lcrzo_ipl serveripl;
  lcrzo_uint16 serverport;
  lcrzo_sock sock;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000125, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &serveripl));

  /* initialize port numbers */
  serverport=(lcrzo_uint16)atoi(argv[2]);

  /* initialize the socket */
  lcrzo_epr(lcrzo_sock_udpmulser_real2(serveripl, serverport,
				       &sock));
  
  /* call the example working on the socket */
  lcrzo_epr(lcrzoex_000124_echo(sock));

  return(LCRZO_ERR_OK);
}
