
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000127=
{ /*reference*/     "lcrzoex", 127,
  /*version*/       1, 0,
  /*title*/         "real multiclient tcp server [echo]",
  /*french title*/  "serveur tcp multiclient reel [echo]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_port",
  /*french usage*/  "port_serveur",
  /*usage example*/ "5566",
  /*fr. usage ex.*/ "5566",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000127_main(int argc, char *argv[]);
int lcrzoex_000127_echo(lcrzo_sock sock, const void *pinfos);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000127_main(int argc, char *argv[])
{ 
  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000127, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_sock_tcpmulser_real((lcrzo_uint16)atoi(argv[1]),
				      &lcrzoex_000127_echo, NULL));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000127_sig_received(int i);
lcrzo_sock lcrzoex_000127_sock;

int lcrzoex_000127_echo(lcrzo_sock sock, const void *pinfos)
{ lcrzo_data data;
  lcrzo_int32 datasize, pid;
  lcrzo_etha clienteth;
  lcrzo_ipl clientip;
  lcrzo_uint16 clientport;
  int ret, language;

  lcrzo_global_get_language(&language);

  /* in case we receive a signal */
  signal(SIGINT, lcrzoex_000127_sig_received);
  lcrzoex_000127_sock=sock;

  while(1)
  { ret=lcrzo_sock_readm(&lcrzoex_000127_sock, LCRZO_TRUE, 
			 &data, &datasize);
    if ( ret!=LCRZO_ERR_OK )
    { if ( language==LCRZO_GLOBAL_FRLANG )
        puts("\nLa lecture sur la socket n'est plus possible.");
      else
	puts("\nWe cannot read from the socket anymore.");
      kill(getpid(), SIGINT);
    }
    if ( datasize!=0 )
    { /* print information about the client */
      lcrzo_epr(lcrzo_sock_get_infos(lcrzoex_000127_sock, NULL,
				     NULL, NULL, NULL,
				     clienteth, &clientip, &clientport));
      pid=getpid();
      printf("[%ld] ", pid);
      if ( language==LCRZO_GLOBAL_FRLANG )
	printf("On a lu");
      else
        printf("We read");
      lcrzo_epr(lcrzo_etha_print(" (client ", clienteth, "-"));
      lcrzo_epr(lcrzo_ipl_print("", clientip, "-"));
      printf("%d) :\n", clientport);
      /* print the read data */
      lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
      /* write back a copy to the socket */
      lcrzo_epr(lcrzo_sock_write(lcrzoex_000127_sock, data, datasize));
      /* if we read 'QUIT', we exit */
      if ( lcrzo_data_search_text(data, datasize, LCRZO_FALSE,
				  +1, -1, "QUIT",
				  NULL, NULL, NULL, NULL)
	   == LCRZO_ERR_OK )
      { pid=getpid();
        printf("[%ld] ", pid);
        if ( language==LCRZO_GLOBAL_FRLANG )
	  puts("Le client quitte");
        else
	  puts("The client sent a QUIT");
        raise(SIGINT);
      }
    }
    lcrzo_data_free(data);
  }
  /* never reatched */
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000127_sig_received(int i)
{ int language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture de la socket (recu : SIG%d)\n", i);
  else
    printf("Closing socket (received : SIG%d)\n", i);
  lcrzo_sock_close(lcrzoex_000127_sock);
  raise(SIGTERM);
}
