
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000128=
{ /*reference*/     "lcrzoex", 128,
  /*version*/       1, 0,
  /*title*/         "real multiclient tcp server [echo] (local ip and IP option)",
  /*french title*/  "server tcp multiclient reel [echo] (ip locale et option IP)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port",
  /*french usage*/  "nom_serveur port_serveur",
  /*usage example*/ "1.2.3.4 5566",
  /*fr. usage ex.*/ "1.2.3.4 5566",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000128_main(int argc, char *argv[]);
int lcrzoex_000127_echo(lcrzo_sock sock, const void *pinfos);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000128_main(int argc, char *argv[])
{ lcrzo_ipl serveripl;
  lcrzo_uint16 serverport;
  lcrzo_ipopt ipopt;
  lcrzo_int8 ipoptsize;
  int language;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000128, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &serveripl));

  /* initialize IP options */
  lcrzo_global_get_language(&language);
  lcrzo_epr(lcrzo_ipopt_stdin((language==LCRZO_GLOBAL_FRLANG)?
                              "options IP":"IP options", "",
                              ipopt, &ipoptsize));

  /* initialize port numbers */
  serverport=(lcrzo_uint16)atoi(argv[2]);

  /* initialize the socket */
  lcrzo_epr(lcrzo_sock_tcpmulser_real2(serveripl, serverport,
				       ipopt, ipoptsize,
				       &lcrzoex_000127_echo, NULL));

  return(LCRZO_ERR_OK);
}
