
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000131=
{ /*reference*/     "lcrzoex", 131,
  /*version*/       1, 0,
  /*title*/         "answer to ARP/ping request for a computer",
  /*french title*/  "repond aux requetes ARP/ping d'une machine",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device spoofed_ethernet_address spoofed_ip_address",
  /*french usage*/  "device adresse_ethernet_usurpee adresse_ip_usurpee",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 1.2.3.4",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 1.2.3.4",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000131_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000131_main(int argc, char *argv[])
{ lcrzo_device device;
  lcrzo_etha ethtospoof;
  lcrzo_ipl iptospoof;
  lcrzo_uint32 mtu;
  lcrzo_sniff sniff;
  lcrzo_data sniffdata;
  lcrzo_int32 sniffdatasize;

  if ( argc<4 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000131, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device, ethernet address and mtu */
  lcrzo_epr(lcrzo_device_init(argv[1], device));
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], ethtospoof));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[3], &iptospoof));
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));

  /* init sniff */
  lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &sniff));

  /* main loop */
  lcrzo_epr(lcrzo_global_set_spoof_printbeforesending(LCRZO_TRUE));
  lcrzo_epr(lcrzo_global_set_spoof_printprofile(LCRZO_PRINTPROFILE_SYNTHSYNTH));
  while ( lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, LCRZO_SNIFF_TYPE_NORMAL, 
			    &sniffdata, &sniffdatasize)==LCRZO_ERR_OK )
  { /*lcrzo_packet_print_eth(sniffdata, sniffdatasize,
                           LCRZO_PRINTPROFILE_SYNTHSYNTH);*/
    lcrzo_epr(lcrzo_virtual_answer_alive(sniffdata, sniffdatasize, 
					 device, ethtospoof, iptospoof));
    lcrzo_data_free(sniffdata);
  }

  /* close everything */
  lcrzo_epr(lcrzo_sniff_close(&sniff));
  return (LCRZO_ERR_OK);
}
