
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000133=
{ /*reference*/     "lcrzoex", 133,
  /*version*/       1, 2,
  /*title*/         "check if TCP seqnum can be predicted",
  /*french title*/  "verifie si les numeros de sequence TCP peuvent etre predits",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device client_name server_name server_port",
  /*french usage*/  "device nom_client nom_serveur port_serveur",
  /*usage example*/ "eth0 1.2.3.4 1.2.3.5 80",
  /*fr. usage ex.*/ "eth0 1.2.3.4 1.2.3.5 80",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000133_main(int argc, char *argv[]);
void lcrzoex_000133_sig_received1(int i);
void lcrzoex_000133_sig_received2(int i);
int lcrzoex_000133_sendsyn(lcrzo_ipl clientipl, 
			   lcrzo_ipl serveripl, 
			   lcrzo_uint16 serverport,
			   lcrzo_uint16 startingclientport,
			   lcrzo_uint32 startingclientseqnum);
int lcrzoex_000133_print(lcrzo_device device,
			 lcrzo_ipl clientipl, 
			 lcrzo_ipl serveripl, 
			 lcrzo_uint16 serverport,
			 lcrzo_uint16 startingclientport,
			 lcrzo_uint32 startingclientseqnum);
int lcrzoex_000133_printseqnum(lcrzo_data sniffdata,
			       lcrzo_int32 sniffdatasize,
			       lcrzo_ipl clientipl, 
			       lcrzo_ipl serveripl, 
			       lcrzo_uint16 serverport,
			       lcrzo_uint16 startingclientport,
			       lcrzo_uint32 startingclientseqnum);

/*-------------------------------------------------------------*/
/* global variables */
int lcrzoex_000133_pid;
lcrzo_spoof lcrzoex_000133_spoof;
lcrzo_sniff lcrzoex_000133_sniff;

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000133_main(int argc, char *argv[])
{ lcrzo_ipl clientipl, serveripl;
  lcrzo_device device;
  lcrzo_uint16 serverport, startingclientport;
  lcrzo_uint32 startingclientseqnum;

  if ( argc<5 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000133, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  lcrzo_epr(lcrzo_device_init(argv[1], device));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[2], &clientipl));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[3], &serveripl));
  serverport=(lcrzo_uint16)atoi(argv[4]);

  /* determine starting values */
  lcrzo_epr(lcrzo_uint16_rand(5000, 30000, &startingclientport));
  lcrzo_epr(lcrzo_uint32_rand(0, 0xEFFFFFFFU, &startingclientseqnum));

  lcrzoex_000133_pid=fork();
  if (lcrzoex_000133_pid<0) return(LCRZO_ERR_FUFORK);
  if (lcrzoex_000133_pid==0)
  { /* this process sends a SYN (we left to our computer the job to send
       a RST) */
    /* in case we receive a signal */
    signal(SIGINT, lcrzoex_000133_sig_received1);
    lcrzo_epr(lcrzoex_000133_sendsyn(clientipl, serveripl, serverport,
				     startingclientport, 
				     startingclientseqnum));
    /*never reatched*/
  }
  else
  { /* this process sniff and prints sequence numbers */
    /* in case we receive a signal */
    signal(SIGINT, lcrzoex_000133_sig_received2);
    lcrzo_epr(lcrzoex_000133_print(device, clientipl, serveripl, serverport,
				   startingclientport, startingclientseqnum));
    /*never reatched*/
  }
  /* never reatched */
  return (LCRZO_ERR_IEINTERNALERROR);
}

/*-------------------------------------------------------------*/
void lcrzoex_000133_sig_received1(int i)
{ int language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture du spoof (recu : SIG%d)\n", i);
  else
    printf("Closing spoof (received : SIG%d)\n", i);
  lcrzo_spoof_close(&lcrzoex_000133_spoof);
  raise(SIGTERM);
}

/*-------------------------------------------------------------*/
void lcrzoex_000133_sig_received2(int i)
{ int status, language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture du sniff (recu : SIG%d)\n", i);
  else
    printf("Closing sniff (received : SIG%d)\n", i);
  kill(lcrzoex_000133_pid, SIGINT);
  waitpid(lcrzoex_000133_pid, &status, 0);
  lcrzo_sniff_close(&lcrzoex_000133_sniff);
  raise(SIGTERM);
}

/*-------------------------------------------------------------*/
int lcrzoex_000133_sendsyn(lcrzo_ipl clientipl, 
			   lcrzo_ipl serveripl, 
			   lcrzo_uint16 serverport,
			   lcrzo_uint16 startingclientport,
			   lcrzo_uint32 startingclientseqnum)
{ lcrzo_hdrlip hdrlip;
  lcrzo_hdrltcp hdrltcp;
  lcrzo_uint16 clientport;
  lcrzo_uint32 clientseqnum;

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  hdrlip.saddr=clientipl;
  hdrlip.daddr=serveripl;

  /* initialize TCP header */
  lcrzo_epr(lcrzo_hdrltcp_initdefault(&hdrltcp));
  hdrltcp.dport=serverport;
  hdrltcp.syn=1;
  clientport=startingclientport;
  clientseqnum=startingclientseqnum;

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&lcrzoex_000133_spoof));
  while(1)
  { lcrzo_epr(lcrzo_spoof_ipopttcpoptdata(&lcrzoex_000133_spoof,
					  hdrlip, NULL, 0,
					  hdrltcp, NULL, 0,
					  NULL, 0));
    hdrltcp.sport=clientport++;
    hdrltcp.seqnum=clientseqnum; clientseqnum+=10;
    lcrzo_epr(lcrzo_time_sleep(100000));
  }
  /*never reatched*/
  return(LCRZO_ERR_IEINTERNALERROR);
}

/*-------------------------------------------------------------*/
int lcrzoex_000133_print(lcrzo_device device,
			 lcrzo_ipl clientipl, 
			 lcrzo_ipl serveripl, 
			 lcrzo_uint16 serverport,
			 lcrzo_uint16 startingclientport,
			 lcrzo_uint32 startingclientseqnum)
{ lcrzo_uint32 mtu;
  lcrzo_data sniffdata;
  lcrzo_int32 sniffdatasize;
  int ret;

  /* init sniff */
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));
  lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &lcrzoex_000133_sniff));

  /* main loop */
  ret=lcrzo_sniff_nextm(&lcrzoex_000133_sniff, LCRZO_TRUE, 
			LCRZO_SNIFF_TYPE_NORMAL, &sniffdata, &sniffdatasize);
  while (ret==LCRZO_ERR_OK)
  { /* decode TCP and print seqnum */
    lcrzo_epr(lcrzoex_000133_printseqnum(sniffdata, sniffdatasize,
					 clientipl, serveripl, serverport,
					 startingclientport, 
					 startingclientseqnum));
    lcrzo_data_free(sniffdata);
    /* sniff next packet */
    ret=lcrzo_sniff_nextm(&lcrzoex_000133_sniff, LCRZO_TRUE,
			  LCRZO_SNIFF_TYPE_NORMAL, &sniffdata, &sniffdatasize);
  }

  /* close everything */
  raise(SIGINT);
  /*never reatched*/
  return(LCRZO_ERR_IEINTERNALERROR);
}

/*-------------------------------------------------------------*/
int lcrzoex_000133_printseqnum(lcrzo_data sniffdata,
			       lcrzo_int32 sniffdatasize,
			       lcrzo_ipl clientipl, 
			       lcrzo_ipl serveripl, 
			       lcrzo_uint16 serverport,
			       lcrzo_uint16 startingclientport,
			       lcrzo_uint32 startingclientseqnum)
{ static lcrzo_uint32 oldseqnum;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrltcp hdrltcp;
  int ret;
  lcrzo_uint32 diff1, diff2;

  /* try to decode it */
  ret=lcrzo_packet_decodem_ethipopttcpoptdata(sniffdata, sniffdatasize,
					      NULL, &hdrlip, NULL, NULL,
					      &hdrltcp, NULL, NULL,
					      NULL, NULL);
  if ( ret!=LCRZO_ERR_OK )
    return(LCRZO_ERR_OK);
  /* only count synack */
  if ( ! (hdrltcp.syn && hdrltcp.ack) )
    return(LCRZO_ERR_OK);
  /* check if the addresses are the one we are looking for */
  if ( ! lcrzo_ipl_equal(hdrlip.saddr, serveripl) )
    return(LCRZO_ERR_OK);
  if ( ! lcrzo_ipl_equal(hdrlip.daddr, clientipl) )
    return(LCRZO_ERR_OK);
  /* check server port */
  if ( hdrltcp.sport!=serverport )
    return(LCRZO_ERR_OK);

  /* now this seems ok, but we verify with starting values */
  diff1=hdrltcp.dport-startingclientport;
  diff2=(hdrltcp.acknum-1-startingclientseqnum)/10;
  if ( diff1!=diff2 )
    return(LCRZO_ERR_OK);

  /* now, it's OK, so we print the seqnum */
  printf("% 6ld : %lu       [diff %ld]\n", diff1, hdrltcp.seqnum,
	 hdrltcp.seqnum-oldseqnum);
  oldseqnum=hdrltcp.seqnum;
 
  return(LCRZO_ERR_OK);
}



