
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000135=
{ /*reference*/     "lcrzoex", 135,
  /*version*/       1, 0,
  /*title*/         "randomly fragmented {ETH,IP,UDP} spoof",
  /*french title*/  "spoof {ETH,IP,UDP} aleatoirement fragmente",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device src_eth dst_eth src_ip dst_ip src_port dst_port",
  /*french usage*/  "device eth_src eth_dst ip_src ip_dst port_src port_dst",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 5.6.7.8 4444 5555",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 5.6.7.8 4444 5555",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000135_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000135_main(int argc, char *argv[])
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_spoof spoof;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrludp hdrludp;
  lcrzo_device device;

  if ( argc<7 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000135, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], hdrleth.src));
  lcrzo_epr(lcrzo_etha_init_eths(argv[3], hdrleth.dst));

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[4], &(hdrlip.saddr)));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[5], &(hdrlip.daddr)));
  hdrlip.protocol=LCRZO_HDRLIP_PROTOCOL_UDP;

  /* initialize UDP header */
  lcrzo_epr(lcrzo_hdrludp_initdefault(&hdrludp));
  hdrludp.sport=(lcrzo_uint16)atoi(argv[6]);
  hdrludp.dport=(lcrzo_uint16)atoi(argv[7]);

  /* main loop */
  lcrzo_epr(lcrzo_spoof_init(&spoof));
  while(1)
  { /* initialize data */
    lcrzo_epr(lcrzo_data_initm_rand(0, 255, 100, &data, &datasize));
    /* change header values */
    lcrzo_uint16_rand(0, 20, &(hdrlip.id));
    lcrzo_uint16_rand(0, 5, &(hdrlip.offsetfrag));
    if (hdrlip.offsetfrag) lcrzo_uint16_rand(1, 0x1FFF, &(hdrlip.offsetfrag));
    lcrzo_uint8_rand(0, 1, &(hdrlip.morefrag));
    /* spoof */
    lcrzo_epr(lcrzo_spoof_ethipoptudpdata(&spoof, device, hdrleth,
					  hdrlip, NULL, 0, hdrludp,
					  data, datasize));
    lcrzo_data_free(data);
  }
  lcrzo_epr(lcrzo_spoof_close(&spoof));

  return(LCRZO_ERR_OK);
}
