
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000136=
{ /*reference*/     "lcrzoex", 136,
  /*version*/       1, 0,
  /*title*/         "Ethernet spoof specified in C",
  /*french title*/  "spoof Ethernet specifie dans le programme C",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device [number [number [number ...]]]",
  /*french usage*/  "device [numero [numero [numero ...]]]",
  /*usage example*/ "eth0 3 2",
  /*fr. usage ex.*/ "eth0 3 2",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000136_main(int argc, char *argv[]);
int lcrzoex_000136_spoof(lcrzo_spoof *pspoof, 
			 lcrzo_device device,
			 lcrzo_int32 number);

/*-------------------------------------------------------------*/
/* global variables */
char lcrzoex_000136_packets[][1600]=
{ "0040954614CB004033E0C2240800"
  "4500001C028C200080018300C0A80A01C0A80A03"
  "080087D8"
  "'blab'",
  "0040954614CB004033E0C2240800"
  "4500001C028C2001800182FFC0A80A01C0A80A03"
  "'lebliblo'",
  "0040954614CB004033E0C2240800"
  "4500001C028C2002800182FEC0A80A01C0A80A03"
  "'blublybl'",
  "0040954614CB004033E0C2240800"
  "45000016028C00038001A303C0A80A01C0A80A03"
  "'a' 00",
  "" /* end with "" */
};
 
/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000136_main(int argc, char *argv[])
{ lcrzo_spoof spoof;
  lcrzo_device device;
  lcrzo_int32 packetcount, i, j;
  int language;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000136, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* find the number of packets */
  packetcount=0;
  while ( lcrzoex_000136_packets[packetcount][0] != '\0' )
  { packetcount++;
  }
  lcrzo_epr(lcrzo_global_get_language(&language));
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Il y a %ld paquets dans le programme C.\n", packetcount);
  else
    printf("There are %ld packets in the C program.\n", packetcount);

  /* initialize spoof */
  lcrzo_epr(lcrzo_spoof_init(&spoof));

  /* if user specified values, spoof only these ones */
  if ( argc == 2 )
  { for ( i=0 ; i<packetcount ; i++ )
    { lcrzo_epr(lcrzoex_000136_spoof(&spoof, device, i+1));
    }
  }
  else
  { for ( j=2 ; j<argc ; j++ )
    { i=atoi(argv[j]);
      if ( i==0 || i>packetcount )
      { if ( language==LCRZO_GLOBAL_FRLANG )
          printf("Numero %s incorrect\n", argv[j]);
        else
	  printf("Number %s incorrect\n", argv[j]);
        return(LCRZO_ERR_BULCRZOEXBADUSAGE);
      }
      lcrzo_epr(lcrzoex_000136_spoof(&spoof, device, i));
    }
  }

  lcrzo_epr(lcrzo_spoof_close(&spoof));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000136_spoof(lcrzo_spoof *pspoof, 
			 lcrzo_device device,
			 lcrzo_int32 number)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  int language;

  lcrzo_epr(lcrzo_global_get_language(&language));
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Envoie le paquet numero %ld\n", number);
  else
    printf("Send packet number %ld\n", number);

  /* initialize data */
  lcrzo_epr(lcrzo_data_initm_mixed(lcrzoex_000136_packets[number-1],
				   &data, &datasize));
  /* spoof */
  lcrzo_epr(lcrzo_spoof_eth(pspoof, device, data, datasize));
  lcrzo_data_free(data);

  return(LCRZO_ERR_OK);
}
