
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000137=
{ /*reference*/     "lcrzoex", 137,
  /*version*/       1, 0,
  /*title*/         "real tcp client [analyze banner]",
  /*french title*/  "client tcp reel [analyse la banniere]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port",
  /*french usage*/  "nom_serveur port_serveur",
  /*usage example*/ "ftp.server.com 21",
  /*fr. usage ex.*/ "ftp.serveur.com 21",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000137_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000137_main(int argc, char *argv[])
{ lcrzo_ipl ipl;
  lcrzo_sock sock;
  lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_string banner, result, resultserver, resultcomputer, resulttype;
  lcrzo_regexp re;
  int language;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000137, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &ipl));
  lcrzo_epr(lcrzo_global_get_language(&language));

  /* initialize the client */
  lcrzo_epr(lcrzo_sock_tcpcli_real(ipl, (lcrzo_uint16)atoi(argv[2]), &sock));
  /* the server prints its banner */
  lcrzo_epr(lcrzo_sock_readm(&sock, LCRZO_TRUE, &data, &datasize));
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_MIXEDN));
  lcrzo_epr(lcrzo_string_initm_data(data, datasize, &banner));
  lcrzo_data_free(data);
  /* we quit */
  lcrzo_epr(lcrzo_data_initm_text("QUIT\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  /* close the socket */
  lcrzo_epr(lcrzo_sock_close(sock));

  /* now, we analyze the banner */
  /*220 xxxx FTP server (Version wu-2.4.2-academ[BETA-18](1) ...*/
  /*220 xxxx FTP server (Version 2.6) ...*/
  if (lcrzo_string_search_regexp(banner, LCRZO_FALSE, +1, -1,
			    "^220 ([^ ]*) FTP server \\(Version ([^ )(]*)",
			    re)==LCRZO_ERR_OK)
  { lcrzo_epr(lcrzo_string_initm_text("ftp", &resulttype));
    lcrzo_epr(lcrzo_string_initm_range(banner,
				       re[2].startindex_positive,
				       re[2].endindex_positive,
				       &resultserver));
    lcrzo_epr(lcrzo_string_initm_range(banner,
				       re[1].startindex_positive,
				       re[1].endindex_positive,
				       &resultcomputer));
  }
  /*220 xxxx FTP server (SunOS 5.7) ready.*/
  else if (lcrzo_string_search_regexp(banner, LCRZO_FALSE, +1, -1,
			    "^220 ([^ ]*) FTP server \\((.*)\\)",
			    re)==LCRZO_ERR_OK)
  { lcrzo_epr(lcrzo_string_initm_text("ftp", &resulttype));
    lcrzo_epr(lcrzo_string_initm_range(banner,
				       re[2].startindex_positive,
				       re[2].endindex_positive,
				       &resultserver));
    lcrzo_epr(lcrzo_string_initm_range(banner,
				       re[1].startindex_positive,
				       re[1].endindex_positive,
				       &resultcomputer));
  }
  /*220 xxxx ESMTP Sendmail 8.9.2/8.9.2; ...*/
  else if (lcrzo_string_search_regexp(banner, LCRZO_FALSE, +1, -1,
			    "^220 ([^ ]*) ESMTP (.*);",
			    re)==LCRZO_ERR_OK)
  { lcrzo_epr(lcrzo_string_initm_text("mail", &resulttype));
    lcrzo_epr(lcrzo_string_initm_range(banner,
				       re[2].startindex_positive,
				       re[2].endindex_positive,
				       &resultserver));
    lcrzo_epr(lcrzo_string_initm_range(banner,
				       re[1].startindex_positive,
				       re[1].endindex_positive,
				       &resultcomputer));
  }
  else
  { if ( language==LCRZO_GLOBAL_FRLANG )
      puts("Banniere non reconnue");
    else
      puts("Unrecognized banner");
    lcrzo_string_free(banner);
    return (LCRZO_ERR_OK);
  }
  lcrzo_string_free(banner);

  /* print the result */
  if ( language==LCRZO_GLOBAL_FRLANG )
  { lcrzo_epr(lcrzo_string_initm_text("Serveur ", &result));
    lcrzo_epr(lcrzo_string_appendm_text(resulttype, &result));
    lcrzo_epr(lcrzo_string_appendm_text(" ", &result));
    lcrzo_epr(lcrzo_string_appendm_text(resultserver, &result));
    lcrzo_epr(lcrzo_string_appendm_text(" sur la machine ", &result));
    lcrzo_epr(lcrzo_string_appendm_text(resultcomputer, &result));
  }
  else
  { lcrzo_epr(lcrzo_string_initm_text("Server ", &result));
    lcrzo_epr(lcrzo_string_appendm_text(resulttype, &result));
    lcrzo_epr(lcrzo_string_appendm_text(" ", &result));
    lcrzo_epr(lcrzo_string_appendm_text(resultserver, &result));
    lcrzo_epr(lcrzo_string_appendm_text(" on computer ", &result));
    lcrzo_epr(lcrzo_string_appendm_text(resultcomputer, &result));
  }
  printf("%s\n", result);
  lcrzo_string_free(resulttype);
  lcrzo_string_free(resultserver);
  lcrzo_string_free(resultcomputer);
  lcrzo_string_free(result);
  return(LCRZO_ERR_OK);
}
