
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000138=
{ /*reference*/     "lcrzoex", 138,
  /*version*/       1, 0,
  /*title*/         "tcp traceroute (spoofed)",
  /*french title*/  "traceroute tcp (spoofe)",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device srceth routereth srcip dstip dstport maxttl",
  /*french usage*/  "device ethsrc ethrouteur ipsrc ipdst portdst ttlmax",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 5.6.7.78 80 30",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 5.6.7.78 80 30",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000138_main(int argc, char *argv[]);
void lcrzoex_000138_sig_received1(int i);
void lcrzoex_000138_sig_received2(int i);
int lcrzoex_000138_traceroute(lcrzo_device device,
			      lcrzo_etha clientetha,
			      lcrzo_etha routeretha,
			      lcrzo_ipl clientipl, 
			      lcrzo_ipl serveripl, 
			      lcrzo_uint16 serverport,
			      lcrzo_uint8 maxttl);
int lcrzoex_000138_sendsyn(lcrzo_device device,
			   lcrzo_etha clientetha,
			   lcrzo_etha routeretha,
			   lcrzo_ipl clientipl, 
			   lcrzo_ipl serveripl, 
			   lcrzo_uint16 serverport,
			   lcrzo_uint16 startingclientport,
			   lcrzo_uint32 startingclientseqnum,
			   lcrzo_uint8 maxttl);
int lcrzoex_000138_print(lcrzo_device device,
			 lcrzo_etha clientetha,
			 lcrzo_etha routeretha,
			 lcrzo_ipl clientipl, 
			 lcrzo_ipl serveripl, 
			 lcrzo_uint16 serverport,
			 lcrzo_uint16 startingclientport,
			 lcrzo_uint32 startingclientseqnum,
			 lcrzo_uint8 maxttl);
int lcrzoex_000138_printroutei(lcrzo_device device,
			       lcrzo_etha clientetha,
			       lcrzo_etha routeretha,
			       lcrzo_ipl clientipl, 
			       lcrzo_ipl serveripl, 
			       lcrzo_uint16 serverport,
			       lcrzo_uint16 startingclientport,
			       lcrzo_uint32 startingclientseqnum,
			       lcrzo_uint8 maxttl,
			       lcrzo_data sniffdata,
			       lcrzo_int32 sniffdatasize);
int lcrzoex_000138_printroutet(lcrzo_device device,
			       lcrzo_etha clientetha,
			       lcrzo_etha routeretha,
			       lcrzo_ipl clientipl, 
			       lcrzo_ipl serveripl, 
			       lcrzo_uint16 serverport,
			       lcrzo_uint16 startingclientport,
			       lcrzo_uint32 startingclientseqnum,
			       lcrzo_uint8 maxttl,
			       lcrzo_data sniffdata,
			       lcrzo_int32 sniffdatasize);

/*-------------------------------------------------------------*/
/* global variables */
int lcrzoex_000138_pid;
lcrzo_spoof lcrzoex_000138_spoof;
lcrzo_sniff lcrzoex_000138_sniff;

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000138_main(int argc, char *argv[])
{ lcrzo_device device;
  lcrzo_etha clientetha, routeretha;
  lcrzo_ipl clientipl, serveripl;
  lcrzo_uint16 serverport;
  lcrzo_uint8 maxttl;

  if ( argc<8 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000138, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  lcrzo_epr(lcrzo_device_init(argv[1], device));
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], clientetha));
  lcrzo_epr(lcrzo_etha_init_eths(argv[3], routeretha));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[4], &clientipl));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[5], &serveripl));
  serverport=(lcrzo_uint16)atoi(argv[6]);
  maxttl=(lcrzo_uint8)atoi(argv[7]);

  /* call the main function */
  lcrzo_epr(lcrzoex_000138_traceroute(device, clientetha, routeretha,
				      clientipl, serveripl, serverport,
				      maxttl));

  return (LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000138_traceroute(lcrzo_device device,
			      lcrzo_etha clientetha,
			      lcrzo_etha routeretha,
			      lcrzo_ipl clientipl, 
			      lcrzo_ipl serveripl, 
			      lcrzo_uint16 serverport,
			      lcrzo_uint8 maxttl)
{ lcrzo_uint16 startingclientport;
  lcrzo_uint32 startingclientseqnum;

  /* determine starting values */
  lcrzo_epr(lcrzo_uint16_rand(5000, 30000, &startingclientport));
  lcrzo_epr(lcrzo_uint32_rand(0, 0xEFFFFFFFU, &startingclientseqnum));

  lcrzoex_000138_pid=fork();
  if (lcrzoex_000138_pid<0) return(LCRZO_ERR_FUFORK);
  if (lcrzoex_000138_pid==0)
  { /* this process sends a SYN */
    /* in case we receive a signal */
    signal(SIGINT, lcrzoex_000138_sig_received1);
    lcrzo_epr(lcrzoex_000138_sendsyn(device, clientetha, routeretha,
				     clientipl, serveripl, serverport,
				     startingclientport, 
				     startingclientseqnum,
				     maxttl));
  }
  else
  { /* this process sniff and prints sequence numbers */
    /* in case we receive a signal */
    signal(SIGINT, lcrzoex_000138_sig_received2);
    lcrzo_epr(lcrzoex_000138_print(device, clientetha, routeretha,
				   clientipl, serveripl, serverport,
				   startingclientport, startingclientseqnum,
				   maxttl));
  }
  return (LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000138_sig_received1(int i)
{ int language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture du spoof (recu : SIG%d)\n", i);
  else
    printf("Closing spoof (received : SIG%d)\n", i);
  lcrzo_spoof_close(&lcrzoex_000138_spoof);
  raise(SIGTERM);
}

/*-------------------------------------------------------------*/
void lcrzoex_000138_sig_received2(int i)
{ int status, language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture du sniff (recu : SIG%d)\n", i);
  else
    printf("Closing sniff (received : SIG%d)\n", i);
  kill(lcrzoex_000138_pid, SIGINT);
  waitpid(lcrzoex_000138_pid, &status, 0);
  lcrzo_sniff_close(&lcrzoex_000138_sniff);
  raise(SIGTERM);
}

/*-------------------------------------------------------------*/
int lcrzoex_000138_sendsyn(lcrzo_device device,
			   lcrzo_etha clientetha,
			   lcrzo_etha routeretha,
			   lcrzo_ipl clientipl, 
			   lcrzo_ipl serveripl, 
			   lcrzo_uint16 serverport,
			   lcrzo_uint16 startingclientport,
			   lcrzo_uint32 startingclientseqnum,
			   lcrzo_uint8 maxttl)
{ lcrzo_hdrleth hdrleth;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrltcp hdrltcp;
  lcrzo_uint8 i;

  /* initialize Ethernet header */
  lcrzo_epr(lcrzo_hdrleth_initdefault(&hdrleth));
  memcpy(hdrleth.src, clientetha, LCRZO_ETHA_MAXBYTES);
  memcpy(hdrleth.dst, routeretha, LCRZO_ETHA_MAXBYTES);

  /* initialize IP header */
  lcrzo_epr(lcrzo_hdrlip_initdefault(&hdrlip));
  hdrlip.saddr=clientipl;
  hdrlip.daddr=serveripl;
  hdrlip.ttl=1;
  hdrlip.id=startingclientport;

  /* initialize TCP header */
  lcrzo_epr(lcrzo_hdrltcp_initdefault(&hdrltcp));
  hdrltcp.dport=serverport;
  hdrltcp.syn=1;
  hdrltcp.sport=startingclientport;
  hdrltcp.seqnum=startingclientseqnum;

  /* spoof */
  lcrzo_epr(lcrzo_spoof_init(&lcrzoex_000138_spoof));
  /*lcrzo_epr(lcrzo_spoof_set_printbeforesending(&lcrzoex_000138_spoof,
                                               LCRZO_TRUE));*/
  for ( i=1 ; i<=maxttl ; i++ )
  { lcrzo_epr(lcrzo_spoof_ethipopttcpoptdata(&lcrzoex_000138_spoof,
					     device, hdrleth,
					     hdrlip, NULL, 0,
					     hdrltcp, NULL, 0,
					     NULL, 0));
    hdrlip.id++;
    hdrlip.ttl++;
    hdrltcp.sport++;
    hdrltcp.seqnum+=10;
    lcrzo_epr(lcrzo_time_sleep(1000000));
  }
  lcrzo_epr(lcrzo_spoof_close(&lcrzoex_000138_spoof));
  
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000138_print(lcrzo_device device,
			 lcrzo_etha clientetha,
			 lcrzo_etha routeretha,
			 lcrzo_ipl clientipl, 
			 lcrzo_ipl serveripl, 
			 lcrzo_uint16 serverport,
			 lcrzo_uint16 startingclientport,
			 lcrzo_uint32 startingclientseqnum,
			 lcrzo_uint8 maxttl)
{ lcrzo_uint32 mtu;
  lcrzo_data sniffdata;
  lcrzo_int32 sniffdatasize;
  int ret;

  /* init sniff */
  lcrzo_epr(lcrzo_mtu_init_device(device, &mtu));
  lcrzo_epr(lcrzo_sniff_init(device, mtu, "", &lcrzoex_000138_sniff));

  /* main loop */
  ret=lcrzo_sniff_nextm(&lcrzoex_000138_sniff, LCRZO_TRUE, 
			LCRZO_SNIFF_TYPE_NORMAL, &sniffdata, &sniffdatasize);
  while (ret==LCRZO_ERR_OK)
  { /* answer to requests */
    lcrzo_epr(lcrzo_virtual_answer_alive(sniffdata, sniffdatasize, 
                                         device, clientetha, clientipl));
    /* decode an icmp error, and print it */
    lcrzo_epr(lcrzoex_000138_printroutei(device, clientetha, routeretha,
					 clientipl, serveripl, serverport,
					 startingclientport, 
					 startingclientseqnum,
					 maxttl, sniffdata, sniffdatasize));
     /* decode a tcp synack, and print it */
    lcrzo_epr(lcrzoex_000138_printroutet(device, clientetha, routeretha,
					 clientipl, serveripl, serverport,
					 startingclientport, 
					 startingclientseqnum,
					 maxttl, sniffdata, sniffdatasize));
    lcrzo_data_free(sniffdata);
    /* sniff next packet */
    ret=lcrzo_sniff_nextm(&lcrzoex_000138_sniff, LCRZO_TRUE,
			  LCRZO_SNIFF_TYPE_NORMAL, &sniffdata, &sniffdatasize);
  }

  /* close everything */
  raise(SIGINT);
  /*never reatched*/
  return(LCRZO_ERR_IEINTERNALERROR);
}

/*-------------------------------------------------------------*/
int lcrzoex_000138_printroutei(lcrzo_device device,
			       lcrzo_etha clientetha,
			       lcrzo_etha routeretha,
			       lcrzo_ipl clientipl, 
			       lcrzo_ipl serveripl, 
			       lcrzo_uint16 serverport,
			       lcrzo_uint16 startingclientport,
			       lcrzo_uint32 startingclientseqnum,
			       lcrzo_uint8 maxttl,
			       lcrzo_data sniffdata,
			       lcrzo_int32 sniffdatasize)
{ lcrzo_hdrleth hdrleth;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrlicmp hdrlicmp;
  lcrzo_data icmpdata;
  lcrzo_uint16 icmpdatasize;
  int ret, index, language;

  /*lcrzo_epr(lcrzo_packet_print_eth(sniffdata, sniffdatasize,
				   LCRZO_PRINTPROFILE_ARRAYDUMP));*/

  /* try to decode icmp */
  ret=lcrzo_packet_decodem_ethipopticmpdata(sniffdata, sniffdatasize,
					    &hdrleth, &hdrlip, NULL, NULL,
					    &hdrlicmp, 
					    &icmpdata, &icmpdatasize);
  if ( ret!=LCRZO_ERR_OK )
    return(LCRZO_ERR_OK);
  /* check if type 11, code 0 */
  if ( ! (hdrlicmp.type==11 || hdrlicmp.code==0) )
  { lcrzo_data_free(icmpdata);
    return(LCRZO_ERR_OK);
  }
  /* check if the addresses are the one we are looking for */
  if ( ! lcrzo_etha_equal(hdrleth.src, routeretha) )
  { lcrzo_data_free(icmpdata);
    return(LCRZO_ERR_OK);
  }
  if ( ! lcrzo_etha_equal(hdrleth.dst, clientetha) )
  { lcrzo_data_free(icmpdata);
    return(LCRZO_ERR_OK);
  }
  if ( ! lcrzo_ipl_equal(hdrlip.daddr, clientipl) )
  { lcrzo_data_free(icmpdata);
    return(LCRZO_ERR_OK);
  }

  /* compute the index from the id of the received packet */
  if ( icmpdatasize<10 )
  { lcrzo_data_free(icmpdata);
    return(LCRZO_ERR_OK);
  }
  index=((icmpdata[8]<<8)|icmpdata[9])-startingclientport+1;
  lcrzo_data_free(icmpdata);

  /* print the result */
  printf("% 3d : ", index);
  lcrzo_epr(lcrzo_ipl_print("", hdrlip.saddr, "\n"));

  /* if maxttl was too short */
  if ( index == maxttl )
  { lcrzo_epr(lcrzo_global_get_language(&language));
    if ( language==LCRZO_GLOBAL_FRLANG )
      printf("maxttl(%d) est trop petit pour atteindre la destination\n", 
	     maxttl);
    else
      printf("maxttl(%d) was too short to reach the destination\n", maxttl);
    raise(SIGINT);
  }

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000138_printroutet(lcrzo_device device,
			       lcrzo_etha clientetha,
			       lcrzo_etha routeretha,
			       lcrzo_ipl clientipl, 
			       lcrzo_ipl serveripl, 
			       lcrzo_uint16 serverport,
			       lcrzo_uint16 startingclientport,
			       lcrzo_uint32 startingclientseqnum,
			       lcrzo_uint8 maxttl,
			       lcrzo_data sniffdata,
			       lcrzo_int32 sniffdatasize)
{ static int destreatched=0;
  lcrzo_hdrleth hdrleth;
  lcrzo_hdrlip hdrlip;
  lcrzo_hdrltcp hdrltcp;
  int ret, index1, index2, language;

  /*lcrzo_epr(lcrzo_packet_print_eth(sniffdata, sniffdatasize,
    LCRZO_PRINTPROFILE_ARRAYDUMP));*/

  /* try to decode it */
  ret=lcrzo_packet_decodem_ethipopttcpoptdata(sniffdata, sniffdatasize,
					      NULL, &hdrlip, NULL, NULL,
					      &hdrltcp, NULL, NULL,
					      NULL, NULL);
  if ( ret!=LCRZO_ERR_OK )
    return(LCRZO_ERR_OK);
  /* only want synack */
  if ( ! (hdrltcp.syn && hdrltcp.ack) )
    return(LCRZO_ERR_OK);
  /* check if the addresses are the one we are looking for */
  if ( ! lcrzo_etha_equal(hdrleth.src, routeretha) )
    return(LCRZO_ERR_OK);
  if ( ! lcrzo_etha_equal(hdrleth.dst, clientetha) )
    return(LCRZO_ERR_OK);
  if ( ! lcrzo_ipl_equal(hdrlip.saddr, serveripl) )
    return(LCRZO_ERR_OK);
  if ( ! lcrzo_ipl_equal(hdrlip.daddr, clientipl) )
    return(LCRZO_ERR_OK);
  /* check server port */
  if ( hdrltcp.sport!=serverport )
    return(LCRZO_ERR_OK);

  /* compute the index from the received packet */
  index1=hdrltcp.dport-startingclientport+1;
  index2=1+(hdrltcp.acknum-1-startingclientseqnum)/10;
  if ( index1!=index2 )
    return(LCRZO_ERR_OK);

  /* we reached the destination */
  lcrzo_epr(lcrzo_global_get_language(&language));
  if ( !destreatched )
  { destreatched=1;
    printf("% 3d : ", index1);
    lcrzo_epr(lcrzo_ipl_print("", hdrlip.saddr, "\n"));
    if ( language==LCRZO_GLOBAL_FRLANG )
    { printf("On se donne 3 secondes pour attendre les eventuelles ");
      printf("reponses retardataires.\n");
    }
    else
    { printf("We continue during 3 seconds to wait for late answers.\n");
    }
    signal(SIGALRM, lcrzoex_000138_sig_received2);
    alarm(3);
  }

  return(LCRZO_ERR_OK);
}




