
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000139=
{ /*reference*/     "lcrzoex", 139, 
  /*version*/       1, 0, 
  /*title*/         "convert a binary number", 
  /*french title*/  "convertit un nombre binaire", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "binary_number",
  /*french usage*/  "nombre_binaire", 
  /*usage example*/ "100100101011011",
  /*fr. usage ex.*/ "100100101011011",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000139_printnumber(lcrzo_uint32 number);
int lcrzoex_000139_printnumberbase(char *string, int base);

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000139_main(int argc, char *argv[]);
int lcrzoex_000139_main(int argc, char *argv[])
{ 
  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000139, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzoex_000139_printnumberbase(argv[1], 2));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000139_printnumberbase(char *string, int base)
{ lcrzo_uint32 i;
  char *p;
  int language;

  lcrzo_epr(lcrzo_global_get_language(&language));
  errno=0;
  i=strtoul(string, &p, base);
  if (*p!='\0')
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Le nombre %s n'est pas en base %d\n", string, base);
    else
      printf("The number %s is not in base %d\n", string, base);
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  if ( errno==ERANGE ) 
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Le nombre %s en base %d est trop long\n", string, base);
    else
      printf("The number %s in base %d is too long\n", string, base);
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzoex_000139_printnumber(i));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000139_printnumber(lcrzo_uint32 number)
{ lcrzo_uint32 i, n, print;
  lcrzo_ipa ipa;
  int language;

  lcrzo_epr(lcrzo_global_get_language(&language));

  /* binary */
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Binaire        : ");
  else
    printf("Binary         : ");
  print=0;
  for ( i=31 ; i>0 ; i-- )
  { n=(number>>i)&1;
    if (print)
    { if ( !((i+1)%4) ) printf(" ");
      printf("%c", (n==0)?'0':'1');
    }
    else
    { if (n==1)
      { print=1;
        printf("1");
      }
    }
  }
  printf("%c\n", (number&1)?'1':'0');

  /* octal */
  printf("Octal          : %lo\n", number);

  /* decimal */
  printf("Decimal        : %lu\n", number);
  if (number<=0xFFFF)
    printf("Decimal 16n    : %u\n", lcrzo_htons(number));
  printf("Decimal 32n    : %lu\n", lcrzo_htonl(number));

  /* hexadecimal */
  printf("Hexa           : %lX\n", number);
  if (number<=0xFFFF)
    printf("Hexa 16n       : %X\n", lcrzo_htons(number));
  printf("Hexa 32n       : %lX\n", lcrzo_htonl(number));

  /* character */
  if ( number<=255 )
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Caractere      : ");
    else
      printf("Character      : ");
    printf("%c\n", (char)number);
  }
  if ( number<=0xFFFF && lcrzo_htons(number)<=255 )
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Caractere 16n  : ");
    else
      printf("Character 16n  : ");
    printf("%c\n", (char)lcrzo_htons(number));
  }
  if ( lcrzo_htonl(number)<=255 )
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Caractere 32n  : ");
    else
      printf("Character 32n  : ");
    printf("%c\n", (char)lcrzo_htonl(number));
  }

  /* IP address */
  lcrzo_epr(lcrzo_ipa_init_ipl(number, ipa));
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Adresse IP     : ");
  else
    printf("IP address     : ");
  printf("%d.%d.%d.%d\n", 
	 (unsigned int)ipa[0], (unsigned int)ipa[1],
	 (unsigned int)ipa[2], (unsigned int)ipa[3]);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Adresse IP 32n : ");
  else
    printf("IP address 32n : ");
  printf("%d.%d.%d.%d\n",
	 (unsigned int)ipa[3], (unsigned int)ipa[2],
	 (unsigned int)ipa[1], (unsigned int)ipa[0]);

  return(LCRZO_ERR_OK);
}



