
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000145=
{ /*reference*/     "lcrzoex", 145, 
  /*version*/       1, 0, 
  /*title*/         "convert a text string", 
  /*french title*/  "convertit une chaine texte", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "\"text\"",
  /*french usage*/  "\"texte\"", 
  /*usage example*/ "\"here a text message\"",
  /*fr. usage ex.*/ "\"ici, un message texte\"",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000145_printdata(lcrzo_data data, lcrzo_int32 datasize);

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000145_main(int argc, char *argv[]);
int lcrzoex_000145_main(int argc, char *argv[])
{ lcrzo_data data;
  lcrzo_int32 datasize;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000145, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_data_initm_text(argv[1], &data, &datasize));
  lcrzo_epr(lcrzoex_000145_printdata(data, datasize));
  lcrzo_data_free(data);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000145_printdata(lcrzo_data data, lcrzo_int32 datasize)
{ int language;

  lcrzo_epr(lcrzo_global_get_language(&language));

  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("***********Texte affichable :\n");
  else
    printf("***********Printable text :\n");
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_PTEXTN));

  printf("***********Dump :\n");
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));

  printf("***********Hexadecimal :\n");
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_HEXAN));

  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("***********Mixte :\n");
  else
    printf("***********Mixed :\n");
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_MIXEDN));

  printf("***********Base 64 :\n");
  lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_BASE64N));
  return (LCRZO_ERR_OK);
}
