
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000149=
{ /*reference*/     "lcrzoex", 149, 
  /*version*/       1, 0, 
  /*title*/         "convert a file from unix to dos", 
  /*french title*/  "convertit un fichier de unix a dos", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "input_file output_file",
  /*french usage*/  "fichier_entree fichier_sortie", 
  /*usage example*/ "/tmp/file /tmp/fileout",
  /*fr. usage ex.*/ "/tmp/fichier /tmp/fichiersortie",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000149_main(int argc, char *argv[]);

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000149_main(int argc, char *argv[])
{ int c, language;
  FILE *pfin, *pfout;   
  lcrzo_string tempofile;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000149, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_global_get_language(&language));
  pfin=fopen(argv[1], "r");
  if (pfin==NULL) 
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Impossible d'ouvrir %s en lecture\n", argv[1]);
    else
      printf("Can not open %s for reading\n", argv[1]);
    return(LCRZO_ERR_FUFOPEN);
  }
  lcrzo_string_initm_text(argv[2], &tempofile);
  lcrzo_string_appendm_text(".tmp_lcrzoex", &tempofile);
  /*it's just an example, we do not check for symlink races*/
  pfout=fopen(tempofile, "w");
  if (pfout==NULL) 
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Impossible d'ouvrir %s en ecriture\n", tempofile);
    else
      printf("Can not open %s for writing\n", tempofile);
    lcrzo_string_free(tempofile);
    return(LCRZO_ERR_FUFOPEN);
  }

  /* conversion */
  c=fgetc(pfin);
  while (!feof(pfin))
  { if (c==0x0D) { }
    else if (c==0x0A)
    { fputc(0x0D, pfout);
      fputc(0x0A, pfout);
    }
    else
    { fputc(c, pfout);
    }
    c=fgetc(pfin);
  }

  if (fclose(pfin)) return(LCRZO_ERR_FUFCLOSE);
  if (fclose(pfout)) return(LCRZO_ERR_FUFCLOSE);

  /* rename tmp file*/
  if (rename(tempofile, argv[2]))
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Impossible de renomer %s en %s\n", tempofile, argv[2]);
    else
      printf("Can not rename %s to %s\n", tempofile, argv[2]);
    lcrzo_string_free(tempofile);
    return(255);
  }
  lcrzo_string_free(tempofile);

  return (LCRZO_ERR_OK);
}
