
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000151=
{ /*reference*/     "lcrzoex", 151, 
  /*version*/       1, 0, 
  /*title*/         "dump the content of a file", 
  /*french title*/  "dumpe le contenu d'un fichier", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "input_file",
  /*french usage*/  "fichier", 
  /*usage example*/ "/tmp/file",
  /*fr. usage ex.*/ "/tmp/fichier",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000151_main(int argc, char *argv[]);

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000151_main(int argc, char *argv[])
{ int c, language, i;
  FILE *pf;   
  lcrzo_uint8 line[16];

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000151, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_global_get_language(&language));
  pf=fopen(argv[1], "r");
  if (pf==NULL) 
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Impossible d'ouvrir %s en lecture\n", argv[1]);
    else
      printf("Can not open %s for reading\n", argv[1]);
    return(LCRZO_ERR_FUFOPEN);
  }

  i=0;
  while (!feof(pf))
  { c=fgetc(pf);
    if ( c==EOF && feof(pf) )
    { lcrzo_data_print(line, i, LCRZO_PRINTTYPE_DUMP);
      continue;
    }
    line[i++]=(lcrzo_uint8)c;
    if ( i==16 )
    { lcrzo_data_print(line, 16, LCRZO_PRINTTYPE_DUMP);
      i=0;
    }
  }
  if (fclose(pf)) return(LCRZO_ERR_FUFCLOSE);

  return (LCRZO_ERR_OK);
}
