
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000161=
{ /*reference*/     "lcrzoex", 161, 
  /*version*/       1, 2, 
  /*title*/         "convert an IP/mask address", 
  /*french title*/  "convertit une adresse IP/masque", 
  /*description*/   "The parameter can be for example :\n"
  "                  1.2.3.0/24\n"
  "                  1.2.0.0/255.255.0.0\n"
  "                  1.2.3.0-1.2.3.255\n"
  "                  1.2.3.4",
  /*french desc.*/  "Le parametre peut par exemple etre :\n"
  "                  1.2.3.0/24\n"
  "                  1.2.0.0/255.255.0.0\n"
  "                  1.2.3.0-1.2.3.255\n"
  "                  1.2.3.4",
  /*usage*/         "ipaddress/mask OR IPinf-IPsup OR IPaddress",
  /*french usage*/  "adresseip/masque OU IPinf-IPsup OU adresseip", 
  /*usage example*/ "192.168.1.1-192.168.3.45",
  /*fr. usage ex.*/ "192.168.1.1-192.168.3.45",
  /*author*/        "Laurent"
};

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000161_main(int argc, char *argv[]);
int lcrzoex_000161_main(int argc, char *argv[])
{ lcrzo_ipl iplinf, iplsup, surroundinf, surroundsup, mask;
  lcrzo_iprange iprange;
  lcrzo_ips ips;
  lcrzo_uint32 nbip;
  int language, i, firsti;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000161, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* print both IP addresses */
  lcrzo_epr(lcrzo_ipl_init_iprange(argv[1], &iplinf, &iplsup));
  lcrzo_ipl_print("IP inf :  ", iplinf, "\n");
  lcrzo_ipl_print("IP sup :  ", iplsup, "\n");

  /* print the range */
  lcrzo_epr(lcrzo_iprange_init_ipl(iplinf, iplsup, iprange));
  printf("Range  :  %s\n", iprange);

  /* print the surrounding range */
  lcrzo_epr(lcrzo_global_get_language(&language));
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Intervalles encadrants :\n");
  else
    printf("Surrounding ranges :\n");
 
  mask=0;
  firsti=-1;
  for ( i=0 ; i<32 ; i++ )
  { mask = 1|(mask<<1);
    if ( (iplinf|mask) == (iplsup|mask) )
    { /* calculate inf */
      surroundinf=iplinf&(~mask);
      lcrzo_epr(lcrzo_ips_init_ipl(surroundinf, ips));
      lcrzo_ips_print(" ", ips, "-");
      /* calculate sup */
      surroundsup=iplinf|mask;
      lcrzo_epr(lcrzo_ips_init_ipl(surroundsup, ips));
      lcrzo_ips_print("", ips, "\t");
      /* print the range */
      lcrzo_epr(lcrzo_iprange_init_ipl(surroundinf, surroundsup, iprange));
      nbip=surroundsup-surroundinf+1;
      if (nbip==0)
        printf("; 4294967296  ;");
      else
	printf("; %9lu  ;", nbip);
      printf("  %s\n", iprange);
      /* print only 16 values */
      if ( firsti == -1 ) firsti=i;
      if ( i>firsti+14 && i<31 ) { printf(" ...\n"); break; }
    }
  }

  return(LCRZO_ERR_OK);
}
