
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>
/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000162=
{ /*reference*/     "lcrzoex", 162,
  /*version*/       1, 3,
  /*title*/         "real tcp client [send email]",
  /*french title*/  "client tcp reel [envoie email]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port 'from@a.b' 'to@c.d' body_filename ['subject']",
  /*french usage*/  "nom_serveur port_serveur  'from@a.b' 'to@c.d' fichier_body ['sujet']",
  /*usage example*/ "1.2.3.4 25 'laurent@s.com' 'dest@d.com' /tmp/file 'here the subject'",
  /*fr. usage ex.*/ "1.2.3.4 25 'laurent@s.com' 'dest@d.com' /tmp/fichier 'ici, le sujet'",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000162_main(int argc, char *argv[]);
int lcrzoex_000162_sendamail(lcrzo_ipl serverip, lcrzo_uint16 serverport,
			     lcrzo_conststring mailfrom, 
			     lcrzo_conststring rcptto,
			     lcrzo_conststring from, 
			     lcrzo_conststring replyto, 
			     lcrzo_conststring to,
			     lcrzo_conststring subject,
			     lcrzo_conststring bodyfilename);
int lcrzoex_000162_verifyresponse1(lcrzo_sock *psock, 
				   lcrzo_uint16 error);
int lcrzoex_000162_verifyresponse2(lcrzo_sock *psock, 
				   lcrzo_uint16 error1, 
				   lcrzo_uint16 error2);
int lcrzoex_000162_verifyresponse3(lcrzo_sock *psock, 
				   lcrzo_uint16 error1, 
				   lcrzo_uint16 error2, 
				   lcrzo_uint16 error3);
int lcrzoex_000162_verifyresponse4(lcrzo_sock *psock, 
				   lcrzo_uint16 error1, 
				   lcrzo_uint16 error2, 
				   lcrzo_uint16 error3, 
				   lcrzo_uint16 error4);
int lcrzoex_000162_generateheaderbody(lcrzo_conststring from,
				      lcrzo_conststring replyto,
				      lcrzo_conststring to,
				      lcrzo_conststring subject, 
				      lcrzo_conststring bodyfilename,
				      lcrzo_data *pdataout,
				      lcrzo_int32 *pdataoutsize);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000162_main(int argc, char *argv[])
{ lcrzo_ipl ipl;

  if ( argc<6 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000162, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_er(lcrzo_ipl_init_hs(argv[1], &ipl));
  lcrzo_er(lcrzoex_000162_sendamail(ipl, (lcrzo_uint16)atoi(argv[2]),
				    argv[3], argv[4], argv[3], argv[3],argv[4],
				    (argc==6)?"":argv[6], argv[5]));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
#define LCRZO_ERR_EXBADRESPONSE 12000
#define LCRZO_ERR_EXBADEMAILAD  12001
int lcrzoex_000162_sendamail(lcrzo_ipl serverip, lcrzo_uint16 serverport,
			     lcrzo_conststring mailfrom, 
			     lcrzo_conststring rcptto,
			     lcrzo_conststring from, 
			     lcrzo_conststring replyto, 
			     lcrzo_conststring to,
			     lcrzo_conststring subject, 
			     lcrzo_conststring bodyfilename)
{ lcrzo_sock sock;
  lcrzo_data data;
  lcrzo_int32 datasize, foundpositive;
  lcrzo_string domainname;
  int ret;

  /* initialize the client domain name */
  ret=lcrzo_string_search_char(mailfrom, LCRZO_FALSE,
			       +1, -1, '@',
			       NULL, &foundpositive);
  if ( ret!=LCRZO_ERR_OK )
  { printf("I didn't found '@' in %s\n", mailfrom); 
    return(LCRZO_ERR_EXBADEMAILAD);
  }
  lcrzo_epr(lcrzo_string_initm_range(mailfrom, foundpositive+1, -1,
				     &domainname));

  /* initialize the client */
  lcrzo_epr(lcrzo_sock_tcpcli_real(serverip, serverport, &sock));

  /* first, we read the banner */
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 220));

  /* then, we send a 'HELO' */
  lcrzo_epr(lcrzo_data_initm_text("HELO ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(domainname, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_string_free(domainname);
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 250));

  /* then, we send a 'MAIL FROM' */
  lcrzo_epr(lcrzo_data_initm_text("Mail From: <", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(mailfrom, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(">\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 250));

  /* then, we send a 'RCPT TO' */
  lcrzo_epr(lcrzo_data_initm_text("Rcpt to: <", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(rcptto, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(">\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 250));

  /* then, we send a 'DATA' */
  lcrzo_epr(lcrzo_data_initm_text("DATA\r\n",
				  &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 354));

  /* then, we send data */
  lcrzo_epr(lcrzoex_000162_generateheaderbody(from, replyto, to, 
					      subject, bodyfilename,
					      &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_data_initm_text(".\r\n",
				  &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 250));

  /* then, we send a 'QUIT' */
  lcrzo_epr(lcrzo_data_initm_text("QUIT\r\n",
				  &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 221));

  /* close the socket */
  lcrzo_epr(lcrzo_sock_close(sock));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000162_verifyresponse(lcrzo_sock *psock, 
				  lcrzo_uint16 error1, 
				  lcrzo_uint16 error2, 
				  lcrzo_uint16 error3, 
				  lcrzo_uint16 error4);
int lcrzoex_000162_verifyresponse(lcrzo_sock *psock, 
				  lcrzo_uint16 error1, 
				  lcrzo_uint16 error2, 
				  lcrzo_uint16 error3, 
				  lcrzo_uint16 error4)
{ lcrzo_data data, response;
  lcrzo_string errorlist;
  lcrzo_int32 datasize, responsesize;
  lcrzo_int32 index, start, end;
  lcrzo_uint16 goterror;
  lcrzo_uint8 newline[3];
  lcrzo_bool notenough;
  int language, ret;

  /* read response from the socket */
  notenough=LCRZO_TRUE;
  newline[0]=0x0D;
  newline[1]=0x0A;
  newline[2]='\0';
  goterror=0; /*just for the compiler*/
  lcrzo_epr(lcrzo_data_initm_data(NULL, 0, &response, &responsesize));
  while (notenough)
  { /* read */
    lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
    lcrzo_epr(lcrzo_data_appendm_data(data, datasize, responsesize, 
				      &response, &responsesize));
    lcrzo_data_free(data);
    /* check for completeness */
    index=0;
    /* the first call should have a null size */
    lcrzo_epr(lcrzo_data_token_data(response, responsesize, 
				    LCRZO_FALSE, -1, +1,
				    newline, 2,
				    &index, NULL, NULL, NULL, NULL));
    /* the second is for us */
    ret=lcrzo_data_token_data(response, responsesize, 
			      LCRZO_FALSE, -1, +1,
			      newline, 2,
			      &index, &start, NULL, &end, NULL);
    if (ret==LCRZO_ERR_OK)
    { /* data will contain the last line */
      lcrzo_epr(lcrzo_data_initm_range(response, responsesize, start, end,
				       &data, &datasize));
      /*lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP);*/

      /* data should contain "xxx " */
      if ( datasize>=4 )
      { if ( isdigit(data[0]) && isdigit(data[1]) && isdigit(data[2]) )
	{ if ( data[3]==' ' ) 
	  { /* ok */
	    notenough=LCRZO_FALSE;
	    data[3]='\0';
	    goterror=atoi(data);
	  }
	}
      }
      lcrzo_data_free(data);
    }
  }
  /* response is not freed */


  /* verify error */
  if ( goterror!=error1 && goterror!=error2 &&
       goterror!=error3 && goterror!=error4 )
  { /* prepare error string */
    lcrzo_epr(lcrzo_string_initm_int(error1, "%d", &errorlist));
    if ( error2 != error1 )
    { lcrzo_epr(lcrzo_string_appendm_char('-', 1, &errorlist));
      lcrzo_epr(lcrzo_string_appendm_int(error2, "%d", &errorlist));
      if ( error3 != error2 )
      { lcrzo_epr(lcrzo_string_appendm_char('-', 1, &errorlist));
	lcrzo_epr(lcrzo_string_appendm_int(error3, "%d", &errorlist));
	if ( error4 != error3 )
	{ lcrzo_epr(lcrzo_string_appendm_char('-', 1, &errorlist));
	  lcrzo_epr(lcrzo_string_appendm_int(error4, "%d", &errorlist));
	}
      }
    }
    /* print message */
    lcrzo_epr(lcrzo_global_get_language(&language));
    if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Je voulais %s, mais j'ai recu %d\n", errorlist, goterror); 
    else
      printf("I wanted %s, but I received %d\n", errorlist, goterror); 
    lcrzo_epr(lcrzo_data_print(response, responsesize , LCRZO_PRINTTYPE_DUMP));
    lcrzo_string_free(errorlist);
    lcrzo_data_free(response);
    return(LCRZO_ERR_EXBADRESPONSE);
  }

  lcrzo_data_free(response);
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000162_verifyresponse1(lcrzo_sock *psock, 
				   lcrzo_uint16 error)
{ return(lcrzoex_000162_verifyresponse(psock, error, error, error, error));
}

/*-------------------------------------------------------------*/
int lcrzoex_000162_verifyresponse2(lcrzo_sock *psock, 
				   lcrzo_uint16 error1, 
				   lcrzo_uint16 error2)
{ return(lcrzoex_000162_verifyresponse(psock, error1, error2, error2, error2));
}

/*-------------------------------------------------------------*/
int lcrzoex_000162_verifyresponse3(lcrzo_sock *psock, 
				   lcrzo_uint16 error1, 
				   lcrzo_uint16 error2, 
				   lcrzo_uint16 error3)
{ return(lcrzoex_000162_verifyresponse(psock, error1, error2, error3, error3));
}

/*-------------------------------------------------------------*/
int lcrzoex_000162_verifyresponse4(lcrzo_sock *psock, 
				   lcrzo_uint16 error1, 
				   lcrzo_uint16 error2, 
				   lcrzo_uint16 error3, 
				   lcrzo_uint16 error4)
{ return(lcrzoex_000162_verifyresponse(psock, error1, error2, error3, error4));
}

/*-------------------------------------------------------------*/
int lcrzoex_000162_generateheaderbody(lcrzo_conststring from,
				      lcrzo_conststring replyto,
				      lcrzo_conststring to,
				      lcrzo_conststring subject, 
				      lcrzo_conststring bodyfilename,
				      lcrzo_data *pdata,
				      lcrzo_int32 *pdatasize)
{ lcrzo_uint32 r;
  lcrzo_int32 datasize, linesize;
  lcrzo_data line;
  char thedate[80];
  time_t thetime;
  int ret, language;
  FILE *stream;

  /* open the file */
  lcrzo_epr(lcrzo_global_get_language(&language));
  lcrzo_epr(lcrzo_stream_open_read(bodyfilename, (LCRZOFILE**)&stream));

  /* generate the header */
  lcrzo_epr(lcrzo_data_initm_text("Message-ID: <", pdata, &datasize));
  lcrzo_epr(lcrzo_uint32_rand(0, 0xFFFFFFFFu, &r));
  lcrzo_epr(lcrzo_data_appendm_int(r, "%08X", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_char('.', 1, datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_uint32_rand(0, 0xFFFFFFFFu, &r));
  lcrzo_epr(lcrzo_data_appendm_int(r, "%08X", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("@domaine.fr>\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Date: ", datasize, pdata, &datasize));
  thetime=time(NULL);
  strftime(thedate, 79, "%a, %d %b %Y %H:%M:%S %z", localtime(&thetime));
  lcrzo_epr(lcrzo_data_appendm_text(thedate, datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("From: <", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(from, datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(">\r\n", datasize, pdata, &datasize));
  if ( strcmp(from, replyto) )
  { lcrzo_epr(lcrzo_data_appendm_text("Reply-To: <", datasize,
				      pdata, &datasize));
    lcrzo_epr(lcrzo_data_appendm_text(replyto, datasize, pdata, &datasize));
    lcrzo_epr(lcrzo_data_appendm_text(">\r\n", datasize, pdata, &datasize));
  }
  lcrzo_epr(lcrzo_data_appendm_text("Organization: Laurent\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("X-Mailer: Laurent Mailer\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("X-Accept-Language: en\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("MIME-Version: 1.0\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("To: <", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(to, datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(">\r\n", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Subject: ", datasize, pdata, &datasize));
  
  if ( strlen(subject) )
  { lcrzo_epr(lcrzo_data_appendm_text(subject, datasize, pdata, &datasize));
  }
  else
  { /* the subject is on the first line of the file */
    lcrzo_epr(lcrzo_stream_readm_line(stream, LCRZO_TRUE, &line, &linesize));
    lcrzo_epr(lcrzo_data_appendm_data(line, linesize, 
				      datasize, pdata, &datasize));
  }

  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Content-Type: text/plain;"
				    " charset=iso-8859-1\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Content-Transfer-Encoding: 8bit\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n",
				    datasize, pdata, &datasize));

  /* generate the body */
  while(1)
  { ret=lcrzo_stream_readm_line(stream, LCRZO_TRUE, &line, &linesize);
    if (ret==LCRZO_ERR_OKDATAEND)
    { break;
    }
    else if (ret==LCRZO_ERR_OK)
    { if ( linesize>254 )
      { if ( language==LCRZO_GLOBAL_FRLANG )
          printf("La ligne semble trop longue: %ld caracteres\n",linesize); 
        else
          printf("Line seems too long: %ld characters\n", linesize); 
      }
      if ( linesize>0 && line[0]=='.' )
      { lcrzo_epr(lcrzo_data_appendm_char('.', 1, datasize, pdata, &datasize));
      }
      lcrzo_epr(lcrzo_data_appendm_data(line, linesize,
					datasize, pdata, &datasize));
      lcrzo_data_free(line);
      lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, pdata, &datasize));
    }
    else
    { lcrzo_stream_close(stream);
      return(ret);
    }
  }
  lcrzo_epr(lcrzo_stream_close(stream));

  /* end */
  if (pdatasize!=NULL) *pdatasize=datasize;
  return(LCRZO_ERR_OK);
}
