
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000163=
{ /*reference*/     "lcrzoex", 163,
  /*version*/       1, 2,
  /*title*/         "real tcp client [send newsgroup message]",
  /*french title*/  "client tcp reel [envoi une message de newsgroup]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port 'from@a.b' 'newsgroup' body_filename ['subject']",
  /*french usage*/  "nom_serveur port_serveur  'from@a.b' 'newgroup' fichier_body ['sujet']",
  /*usage example*/ "1.2.3.4 119 'laurent@s.com' 'alt.test' /tmp/file 'here the subject'",
  /*fr. usage ex.*/ "1.2.3.4 119 'laurent@s.com' 'alt.test' /tmp/fichier 'ici, le sujet'",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000163_main(int argc, char *argv[]);
int lcrzoex_000163_sendamesg(lcrzo_ipl serverip, lcrzo_uint16 serverport,
			     lcrzo_conststring from,
			     lcrzo_conststring newsgroup,
			     lcrzo_conststring subject,
			     lcrzo_conststring bodyfilename);
int lcrzoex_000162_verifyresponse1(lcrzo_sock *psock, 
				   lcrzo_uint16 error);
int lcrzoex_000163_generateheaderbody(lcrzo_conststring from,
				      lcrzo_conststring newsgroup,
				      lcrzo_conststring subject, 
				      lcrzo_conststring bodyfilename,
				      lcrzo_data *pdataout,
				      lcrzo_int32 *pdataoutsize);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000163_main(int argc, char *argv[])
{ lcrzo_ipl ipl;

  if ( argc<6 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000163, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_er(lcrzo_ipl_init_hs(argv[1], &ipl));
  lcrzo_er(lcrzoex_000163_sendamesg(ipl, (lcrzo_uint16)atoi(argv[2]),
				    argv[3], argv[4], 
				    (argc==6)?"":argv[6], argv[5]));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
#define LCRZO_ERR_EXBADRESPONSE 12000
#define LCRZO_ERR_EXBADEMAILAD  12001
int lcrzoex_000163_sendamesg(lcrzo_ipl serverip, lcrzo_uint16 serverport,
			     lcrzo_conststring from,
			     lcrzo_conststring newsgroup,
			     lcrzo_conststring subject, 
			     lcrzo_conststring bodyfilename)
{ lcrzo_sock sock;
  lcrzo_data data;
  lcrzo_int32 datasize;

  /* initialize the client */
  lcrzo_epr(lcrzo_sock_tcpcli_real(serverip, serverport, &sock));

  /* first, we read the banner */
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 200));

  /* then, we send a 'MODE READER' */
  lcrzo_epr(lcrzo_data_initm_text("MODE READER\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 200));

  /* then, we send a 'GROUP xx' */
  lcrzo_epr(lcrzo_data_initm_text("GROUP ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(newsgroup, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 211));

  /* then, we send a 'POST' */
  lcrzo_epr(lcrzo_data_initm_text("POST\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 340));
  /* then, we send data */
  lcrzo_epr(lcrzoex_000163_generateheaderbody(from, newsgroup, 
					      subject, bodyfilename,
					      &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_data_initm_text(".\r\n",
				  &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 240));

  /* then, we send a 'QUIT' */
  lcrzo_epr(lcrzo_data_initm_text("QUIT\r\n",
				  &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 205));

  /* close the socket */
  lcrzo_epr(lcrzo_sock_close(sock));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000163_generateheaderbody(lcrzo_conststring from,
				      lcrzo_conststring newsgroup,
				      lcrzo_conststring subject, 
				      lcrzo_conststring bodyfilename,
				      lcrzo_data *pdata,
				      lcrzo_int32 *pdatasize)
{ lcrzo_uint32 r;
  lcrzo_int32 datasize, linesize;
  lcrzo_data line;
  char thedate[80];
  time_t thetime;
  int language, ret;
  FILE *stream;   

  /* open the file */
  lcrzo_epr(lcrzo_global_get_language(&language));
  lcrzo_epr(lcrzo_stream_open_read(bodyfilename, (LCRZOFILE**)&stream));

  /* generate the header */
  lcrzo_epr(lcrzo_data_initm_text("Message-ID: <", pdata, &datasize));
  lcrzo_epr(lcrzo_uint32_rand(0, 0xFFFFFFFFu, &r));
  lcrzo_epr(lcrzo_data_appendm_int(r, "%08X", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_char('.', 1, datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_uint32_rand(0, 0xFFFFFFFFu, &r));
  lcrzo_epr(lcrzo_data_appendm_int(r, "%08X", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("@domaine.fr>\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Date: ", datasize, pdata, &datasize));
  thetime=time(NULL);
  strftime(thedate, 79, "%a, %d %b %Y %H:%M:%S %z", localtime(&thetime));
  lcrzo_epr(lcrzo_data_appendm_text(thedate, datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("From: <", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(from, datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(">\r\n", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Organization: Laurent\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("X-Mailer: Laurent Mailer\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("X-Accept-Language: en\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("MIME-Version: 1.0\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Newsgroups: ", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(newsgroup, datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Subject: ", datasize, pdata, &datasize));
  
  if ( strlen(subject) )
  { lcrzo_epr(lcrzo_data_appendm_text(subject, datasize, pdata, &datasize));
  }
  else
  { /* the subject is on the first line of the file */
    lcrzo_epr(lcrzo_stream_readm_line(stream, LCRZO_TRUE, &line, &linesize));
    lcrzo_epr(lcrzo_data_appendm_data(line, linesize, 
                                      datasize, pdata, &datasize));
  }

  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Content-Type: text/plain; charset=iso-8859-1\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("Content-Transfer-Encoding: 8bit\r\n",
				    datasize, pdata, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n",
				    datasize, pdata, &datasize));

  /* generate the body */
  while(1)
  { ret=lcrzo_stream_readm_line(stream, LCRZO_TRUE, &line, &linesize);
    if (ret==LCRZO_ERR_OKDATAEND)
    { break;
    }
    else if (ret==LCRZO_ERR_OK)
    { if ( linesize>250 )
      { if ( language==LCRZO_GLOBAL_FRLANG )
          printf("La ligne me semble trop longue: %ld caracteres\n",linesize); 
        else
          printf("Line seems to be too long: %ld characters\n", linesize); 
      }
      if ( linesize>0 && line[0]=='.' )
      { lcrzo_epr(lcrzo_data_appendm_char('.', 1, datasize, pdata, &datasize));
      }
      lcrzo_epr(lcrzo_data_appendm_data(line, linesize,
                                        datasize, pdata, &datasize));
      lcrzo_data_free(line);
      lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, pdata, &datasize));
    }
    else
    { lcrzo_stream_close(stream);
      return(ret);
    }
  }
  lcrzo_epr(lcrzo_stream_close(stream));

  /* end */
  if (pdatasize!=NULL) *pdatasize=datasize;
  return(LCRZO_ERR_OK);
}



