
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>


/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000165=
{ /*reference*/     "lcrzoex", 165,
  /*version*/       1, 0,
  /*title*/         "real tcp client [recursive ftp put]",
  /*french title*/  "client tcp reel [envoi recursif ftp]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port login local_dir distant_dir",
  /*french usage*/  "nom_serveur port_serveur login rep_local rep_distant",
  /*usage example*/ "1.2.3.4 21 bob /tmp/here .",
  /*fr. usage ex.*/ "1.2.3.4 21 bob /tmp/here .",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000165_main(int argc, char *argv[]);
int lcrzoex_000165_recursiveftpput(lcrzo_ipl serverip,
				   lcrzo_uint16 serverport,
				   lcrzo_conststring login,
				   lcrzo_conststring localdir,
				   lcrzo_conststring distantdir);
int lcrzoex_000165_recursiveput(lcrzo_sock *psock, 
				lcrzo_conststring abslocaldir,
				lcrzo_conststring rellocaldir);
int lcrzoex_000165_putfile(lcrzo_sock *psock, 
			   lcrzo_conststring absfilename, 
			   lcrzo_int32 filesize,
			   lcrzo_conststring relfilename);
int lcrzoex_000165_getpasvipport(lcrzo_sock *psock, 
				 lcrzo_ipl *pipl,
				 lcrzo_uint16 *pport);
int lcrzoex_000162_verifyresponse1(lcrzo_sock *psock, 
				   lcrzo_uint16 error);
int lcrzoex_000162_verifyresponse2(lcrzo_sock *psock, 
				   lcrzo_uint16 error1, 
				   lcrzo_uint16 error2);
int lcrzoex_000162_verifyresponse3(lcrzo_sock *psock, 
				   lcrzo_uint16 error1, 
				   lcrzo_uint16 error2, 
				   lcrzo_uint16 error3);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000165_main(int argc, char *argv[])
{ lcrzo_ipl ipl;

  if ( argc<6 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000165, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &ipl));
  lcrzo_epr(lcrzoex_000165_recursiveftpput(ipl, (lcrzo_uint16)atoi(argv[2]),
					   argv[3], argv[4], argv[5]));
  puts("Fin - End");
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
#define LCRZO_ERR_EXBADRESPONSE 12000
#define LCRZO_ERR_EXOPENDIR     12001
#define LCRZO_ERR_EXCLOSEDIR    12002
int lcrzoex_000165_recursiveftpput(lcrzo_ipl serverip,
				   lcrzo_uint16 serverport,
				   lcrzo_conststring login,
				   lcrzo_conststring localdir,
				   lcrzo_conststring distantdir)
{ lcrzo_sock sock;
  lcrzo_data data;
  lcrzo_int32 datasize;

  /* initialize the client */
  lcrzo_epr(lcrzo_sock_tcpcli_real(serverip, serverport, &sock));

  /* first, we read the banner */
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 220));

  /* then, we send a 'USER' */
  lcrzo_epr(lcrzo_data_initm_text("USER ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(login, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 331));

  /* then, we send a 'PASS' */
  lcrzo_epr(lcrzo_data_initm_text("PASS ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text_passwd("Passwd", "",
					    datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 230));

  /* then, we send a 'TYPE I' */
  lcrzo_epr(lcrzo_data_initm_text("TYPE I\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 200));

  /* treat every file */  
  lcrzo_epr(lcrzoex_000165_recursiveput(&sock, localdir, distantdir));

  /* then, we send a 'QUIT' */
  lcrzo_epr(lcrzo_data_initm_text("QUIT\r\n",
				  &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(sock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(&sock, 221));

  /* close the socket */
  lcrzo_epr(lcrzo_sock_close(sock));
  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000165_recursiveput(lcrzo_sock *psock, 
				lcrzo_conststring abslocaldir,
				lcrzo_conststring rellocaldir)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_string localfile;
  DIR *pdir;
  struct dirent *pdirent;
  struct stat st;
  int ret, language;

  /* we send a 'MKD dir' */
  lcrzo_epr(lcrzo_data_initm_text("MKD ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(rellocaldir, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse3(psock, 257, 550, 521));

  /* we send a 'CWD dir' */
  lcrzo_epr(lcrzo_data_initm_text("CWD ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(rellocaldir, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(psock, 250));

  /* open directory */
  pdir=opendir(abslocaldir);
  if (pdir==NULL) return(LCRZO_ERR_EXOPENDIR);

  /* go through the directory */
  lcrzo_epr(lcrzo_global_get_language(&language));
  pdirent=readdir(pdir);
  while(pdirent!=NULL)
  { /* ignore . and .. */
    if ( !strcmp(pdirent->d_name, ".") || !strcmp(pdirent->d_name, "..") )
    { pdirent=readdir(pdir);
      continue;
    }
    /* set the local file */
    lcrzo_epr(lcrzo_string_initm_text(abslocaldir, &localfile));
    if ( abslocaldir[strlen(abslocaldir)-1] != '/' )
    { lcrzo_epr(lcrzo_string_appendm_char('/', 1, &localfile));
    }
    lcrzo_epr(lcrzo_string_appendm_text(pdirent->d_name, &localfile));
    /* stat it */
    ret=stat(localfile, &st);
    if (ret==-1) return(LCRZO_ERR_FUSTAT);
    if (S_ISDIR(st.st_mode))
    { if ( language==LCRZO_GLOBAL_FRLANG )
        printf("%s est un repertoire\n", localfile);
      else
        printf("%s is a directory\n", localfile);
      lcrzo_epr(lcrzoex_000165_recursiveput(psock, localfile, 
					    pdirent->d_name));
    }
    else if (S_ISREG(st.st_mode))
    { if ( language==LCRZO_GLOBAL_FRLANG )
        printf("%s est un fichier\n", localfile);
      else
	printf("%s is regular\n", localfile);
      lcrzo_epr(lcrzoex_000165_putfile(psock, localfile, st.st_size,
				       pdirent->d_name));
    }
    lcrzo_string_free(localfile);
    pdirent=readdir(pdir);
  }

  /* close the directory */
  ret=closedir(pdir);
  if (ret) return(LCRZO_ERR_EXCLOSEDIR);

  /* we send a 'CWD ..' */
  lcrzo_epr(lcrzo_data_initm_text("CWD ..\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(psock, 250));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000165_putfile(lcrzo_sock *psock, 
			   lcrzo_conststring absfilename,
			   lcrzo_int32 filesize,
			   lcrzo_conststring relfilename)
{ lcrzo_data data;
  lcrzo_int32 datasize, servsize;
  lcrzo_ipl pasvipl;
  lcrzo_uint16 pasvport;
  lcrzo_string sizeserver;
  lcrzo_sock datasock;
  lcrzo_regexp re;
  int c, language, ret;
  FILE *pfin;   

  /* get the port to which connect */
  lcrzo_epr(lcrzoex_000165_getpasvipport(psock, &pasvipl, &pasvport));
  /*lcrzo_ipl_print("IP : ", pasvipl, ":");
    printf("%d\n", pasvport);*/

  /* initialize the data connexion */
  lcrzo_epr(lcrzo_sock_tcpcli_real(pasvipl, pasvport, &datasock));
  
  /* we send a 'STOR file' */
  lcrzo_epr(lcrzo_data_initm_text("STOR ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(relfilename, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzoex_000162_verifyresponse1(psock, 150));

  /* write data to the file */
  lcrzo_epr(lcrzo_global_get_language(&language));
  pfin=fopen(absfilename, "r");
  if (pfin==NULL) 
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Impossible d'ouvrir %s en lecture\n", absfilename);
    else
      printf("Can not open %s for reading\n", absfilename);
    return(LCRZO_ERR_FUFOPEN);
  }
  c=fgetc(pfin);
  while (!feof(pfin))
  { lcrzo_epr(lcrzo_sock_write(datasock, (char*)&c, 1));
    c=fgetc(pfin);
  }
  if (fclose(pfin)) return(LCRZO_ERR_FUFCLOSE);

  /* close the data connexion */
  lcrzo_epr(lcrzo_sock_close(datasock));
  lcrzo_epr(lcrzoex_000162_verifyresponse1(psock, 226));

  /* we send a 'SIZE file' */
  lcrzo_epr(lcrzo_data_initm_text("SIZE ", &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text(relfilename, datasize, &data, &datasize));
  lcrzo_epr(lcrzo_data_appendm_text("\r\n", datasize, &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
  ret=lcrzo_data_search_regexp(data, datasize, LCRZO_FALSE, +1, -1,
			       "213 ([0-9]*)", re);
  if ( ret!=LCRZO_ERR_OK )
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Je voulais 213, mais j'ai recu :\n"); 
    else
      printf("I wanted 213, but I received :\n"); 
    lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
    lcrzo_data_free(data);
    return(LCRZO_ERR_EXBADRESPONSE);
  }
  lcrzo_epr(lcrzo_string_initm_range(data, re[1].startindex_positive,
				     re[1].endindex_positive, &sizeserver));
  servsize=atoi(sizeserver);
  lcrzo_string_free(sizeserver);
  lcrzo_data_free(data);
  /* verify size */
  if ( filesize!=servsize )
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Les tailles sont differentes : %ld %ld, je reessaie\n",
	     filesize, servsize); 
    else
      printf("The sizes are differents : %ld %ld, we retry\n",
	     filesize, servsize); 
    /* retry */
    lcrzo_epr(lcrzoex_000165_putfile(psock, absfilename, filesize,
				     relfilename));
  }

  /* this is very DANGEROUS to uncomment this : it DELETEs the local file */
  /*# ret=unlink(absfilename);
    # if (ret) return(255);
  */

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
int lcrzoex_000165_getpasvipport(lcrzo_sock *psock, 
				 lcrzo_ipl *pipl,
				 lcrzo_uint16 *pport)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_string string;
  lcrzo_uint8 pasvvalues[6];
  lcrzo_regexp re;
  int i, ret, language;

  lcrzo_epr(lcrzo_global_get_language(&language));

  /* we send a 'PASV' */
  lcrzo_epr(lcrzo_data_initm_text("PASV\r\n", &data, &datasize));
  lcrzo_epr(lcrzo_sock_write(*psock, data, datasize));
  lcrzo_data_free(data);
  lcrzo_epr(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
  ret=lcrzo_data_search_regexp(data, datasize, LCRZO_FALSE, +1, -1,
			       "227 Entering Passive Mode \\("
			       "([0-9]+),([0-9]+),([0-9]+),"
			       "([0-9]+),([0-9]+),([0-9]+)\\)", re);
  if ( ret!=LCRZO_ERR_OK )
  { if ( language==LCRZO_GLOBAL_FRLANG )
      printf("Je voulais 227, mais j'ai recu :\n"); 
    else
      printf("I wanted 227, but I received :\n"); 
    lcrzo_epr(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
    lcrzo_data_free(data);
    return(LCRZO_ERR_EXBADRESPONSE);
  }

  /* we set each value */
  data[datasize]='\0';
  for ( i=0 ; i<6 ; i++ )
  { lcrzo_epr(lcrzo_string_initm_range(data, re[i+1].startindex_positive,
				       re[i+1].endindex_positive, &string));
    pasvvalues[i]=(lcrzo_uint8)atoi(string);
    lcrzo_string_free(string);
  }
  lcrzo_data_free(data);

  /* initialize return value */
  lcrzo_epr(lcrzo_ipl_init_ipa(pasvvalues, pipl));
  if (pport!=NULL) *pport=(lcrzo_uint16)((pasvvalues[4]<<8)|pasvvalues[5]);

  return(LCRZO_ERR_OK);
}
 
