
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000167=
{ /*reference*/     "lcrzoex", 167,
  /*version*/       1, 0,
  /*title*/         "real tcp client [stdin] with loose source routing",
  /*french title*/  "client tcp reel [stdin] avec loose source routing",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port router_name",
  /*french usage*/  "nom_serveur port_serveur nom_routeur",
  /*usage example*/ "1.2.3.4 80 5.6.7.8",
  /*fr. usage ex.*/ "1.2.3.4 80 5.6.7.8",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000167_main(int argc, char *argv[]);
int lcrzoex_000084_stdin_sock(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000167_main(int argc, char *argv[])
{ lcrzo_ipl iplserver, iplrouter, iplnull;
  lcrzo_ipopt ipopt;
  lcrzo_uint8 ipoptsize;
  lcrzo_sock sock;

  if ( argc<4 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000167, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize the adresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &iplserver));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[3], &iplrouter));

  /* initialize the options */
  lcrzo_epr(lcrzo_ipl_initdefault(&iplnull));
  lcrzo_epr(lcrzo_ipopt_init_lsrr(iplrouter, 
				  iplnull, iplnull, iplnull, iplnull,
                                  iplnull, iplnull, iplnull, iplnull,
                                  1, ipopt, &ipoptsize));

  /* initlialize the client */
  lcrzo_epr(lcrzo_sock_tcpcli_real2(0, iplserver,
				    0, (lcrzo_uint16)atoi(argv[2]), 
				    ipopt, ipoptsize,
				    &sock));

  /* use stdin to enter data */
  lcrzo_epr(lcrzoex_000084_stdin_sock(sock));

  return(LCRZO_ERR_OK);
}
