
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000168=
{ /*reference*/     "lcrzoex", 168,
  /*version*/       1, 1,
  /*title*/         "real udp client [pipe]",
  /*french title*/  "client udp reel [pipe]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "server_name server_port",
  /*french usage*/  "nom_serveur port_serveur",
  /*usage example*/ "1.2.3.4 53",
  /*fr. usage ex.*/ "1.2.3.4 53",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000168_main(int argc, char *argv[]);
int lcrzoex_000168_pipe_sock(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000168_main(int argc, char *argv[])
{ lcrzo_ipl ipl;
  lcrzo_sock sock;

  if ( argc<3 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000168, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &ipl));
  lcrzo_epr(lcrzo_sock_udpcli_real(ipl, (lcrzo_uint16)atoi(argv[2]), &sock));
  lcrzo_epr(lcrzoex_000168_pipe_sock(sock));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000168_sig_received(int i);
int lcrzoex_000168_pid;
lcrzo_sock lcrzoex_000168_sock;
int lcrzoex_000168_pipe_sock(lcrzo_sock sock)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  int ret, language;

  lcrzo_global_get_language(&language);

  /* in case we receive a signal */
  signal(SIGINT, lcrzoex_000168_sig_received);
  lcrzoex_000168_sock=sock;

  lcrzoex_000168_pid=fork();
  if (lcrzoex_000168_pid<0) return(LCRZO_ERR_FUFORK);
  if (lcrzoex_000168_pid==0)
  { /* this process prints read data (child) */
    while(1)
    { ret=lcrzo_sock_readm(&lcrzoex_000168_sock, LCRZO_TRUE, 
			   &data, &datasize);
      if ( ret!=LCRZO_ERR_OK )
      { if ( language==LCRZO_GLOBAL_FRLANG )
	  puts("\nLa lecture sur la socket n'est plus possible.");
        else
	  puts("\nWe cannot read from the socket anymore.");
        kill(getppid(), SIGINT);
	_exit(ret);
      }
      if ( datasize!=0 )
      { lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_TEXT);
      }
      lcrzo_data_free(data);
    }
    /* never reatched */
  }
  else
  { /* this process writes data */
    while(1)
    { lcrzo_epr(lcrzo_fd_readm(0, LCRZO_TRUE, &data, &datasize));
      ret=lcrzo_sock_write(lcrzoex_000168_sock, data, datasize);
      lcrzo_data_free(data);
      if (ret!=LCRZO_ERR_OK)
      { if ( language==LCRZO_GLOBAL_FRLANG )
	  puts("\nL'ecriture sur la socket n'est plus possible.");
        else 
	  puts("\nWe cannot write to the socket anymore.");
        raise(SIGINT);
      }
    }
    /* never reatched */
  }
  /* never reatched */
  return (LCRZO_ERR_IEINTERNALERROR);
}

/*-------------------------------------------------------------*/
void lcrzoex_000168_sig_received(int i)
{ int status, language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture de la socket (recu : SIG%d)\n", i);
  else
    printf("Closing socket (received : SIG%d)\n", i);
  kill(lcrzoex_000168_pid, SIGTERM);
  waitpid(lcrzoex_000168_pid, &status, 0);
  lcrzo_sock_close(lcrzoex_000168_sock);
  raise(SIGTERM);
}
