
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000169=
{ /*reference*/     "lcrzoex", 169,
  /*version*/       1, 0,
  /*title*/         "virtual udp client [pipe]",
  /*french title*/  "client udp virtuel [pipe]",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "device clieth serveth cliname servname cliport servport",
  /*french usage*/  "device ethcli ethserv nomcli nomserv portcli portserv",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 1.2.3.5 4444 53",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 11:22:33:44:55:66 1.2.3.4 1.2.3.5 4444 53",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000169_main(int argc, char *argv[]);
int lcrzoex_000168_pipe_sock(lcrzo_sock sock);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000169_main(int argc, char *argv[])
{ lcrzo_etha servereth, clienteth;
  lcrzo_ipl serveripl, clientipl;
  lcrzo_uint16 serverport, clientport;
  lcrzo_sock sock;

  if ( argc<8 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000169, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize Ethernet addresses */
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], clienteth));
  lcrzo_epr(lcrzo_etha_init_eths(argv[3], servereth));

  /* initialize IP addresses */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[4], &clientipl));
  lcrzo_epr(lcrzo_ipl_init_hs(argv[5], &serveripl));

  /* initialize port numbers */
  clientport=(lcrzo_uint16)atoi(argv[6]);
  serverport=(lcrzo_uint16)atoi(argv[7]);

  /* initialize the socket */
  lcrzo_epr(lcrzo_sock_udpcli_virt(argv[1],
				   clienteth, servereth,
				   clientipl, serveripl, 
				   clientport, serverport,
				   &sock));
 
  /* call the example working on the socket */
  lcrzo_epr(lcrzoex_000168_pipe_sock(sock));

  return(LCRZO_ERR_OK);
}
