
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000172=
{ /*reference*/     "lcrzoex", 172,
  /*version*/       1, 0,
  /*title*/         "tcp traceroute",
  /*french title*/  "traceroute tcp",
  /*description*/   "openport has to be an open port on ipaddress computer",
  /*french desc.*/  "portouvert doit etre ouvert sur la machine adresseip",
  /*usage*/         "ipaddress openport maxttl",
  /*french usage*/  "adresseip portouvert ttlmax",
  /*usage example*/ "1.2.3.4 80 30",
  /*fr. usage ex.*/ "1.2.3.4 80 30",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000172_main(int argc, char *argv[]);
int lcrzoex_000138_traceroute(lcrzo_device device,
			      lcrzo_etha clientetha,
			      lcrzo_etha routeretha,
			      lcrzo_ipl clientipl, 
			      lcrzo_ipl serveripl, 
			      lcrzo_uint16 serverport,
			      lcrzo_uint8 maxttl);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000172_main(int argc, char *argv[])
{ lcrzo_device device;
  lcrzo_etha clientetha, routeretha;
  lcrzo_ipl clientipl, serveripl;
  lcrzo_uint16 serverport;
  lcrzo_uint8 maxttl;

  if ( argc<4 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000172, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &serveripl));
  serverport=(lcrzo_uint16)atoi(argv[2]);
  maxttl=(lcrzo_uint8)atoi(argv[3]);

  /* get necessary addresses */
  lcrzo_epr(lcrzo_conf_route_to_host(serveripl,
				     device, clientetha, routeretha,
				     &clientipl, NULL));

  /* call the main function */
  lcrzo_epr(lcrzoex_000138_traceroute(device, clientetha, routeretha,
				      clientipl, serveripl, serverport,
				      maxttl));

  return (LCRZO_ERR_OK);
}
