
/* include the library headers */
#include <lcrzo.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000173=
{ /*reference*/     "lcrzoex", 173, 
  /*version*/       1, 0, 
  /*title*/         "print informations about the computer (devices) - simple", 
  /*french title*/  "affiche les informations sur la machine (devices) - simple", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "",
  /*french usage*/  "", 
  /*usage example*/ "",
  /*fr. usage ex.*/ "",
  /*author*/        "Laurent"
};

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000173_main(int argc, char *argv[]);
int lcrzoex_000173_main(int argc, char *argv[])
{ lcrzo_int32 count, i;
  lcrzo_device device;
  lcrzo_etha etha;
  lcrzo_ipl ipl, mask;
  lcrzo_uint32 mtu;
  lcrzo_bool isup, isanalias;

  /*look at example 158 if you want the results to be nicely displayed*/

  /* we loop through the number of devices */
  lcrzo_er(lcrzo_conf_devices_count(&count));
  for ( i=1 ; i<=count ; i++ )
  { /*get the information*/
    lcrzo_epr(lcrzo_conf_devices_value_pos(i,
					   device,
					   etha,
					   &ipl, &mask,
					   &mtu, &isup, &isanalias));
    /*print the information*/
    printf("\ndevice : %s ", device);
    printf("(mtu:%lu, isup:%d, isanalias:%d)\n", mtu, isup, isanalias);
    lcrzo_etha_print("Ethernet : ", etha, "\n");
    lcrzo_ipl_print("IP :       ", ipl, "/");
    lcrzo_ipl_print("", mask, "\n");
  }  
  return(LCRZO_ERR_OK);
}
