
/* include the library headers */
#include <lcrzo.h>
#include <stdio.h>

/* set information about this example */
lcrzoex_infos lcrzoex_000175=
{ /*reference*/     "lcrzoex", 175, 
  /*version*/       1, 0, 
  /*title*/         "print informations about the computer (routes) - simple", 
  /*french title*/  "affiche les informations sur la machine (routes) - simple", 
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "",
  /*french usage*/  "", 
  /*usage example*/ "",
  /*fr. usage ex.*/ "",
  /*author*/        "Laurent"
};

/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000175_main(int argc, char *argv[]);
int lcrzoex_000175_main(int argc, char *argv[])
{ lcrzo_int32 count, i;
  lcrzo_device device;
  lcrzo_ipl ipl, mask, source, gw;
  lcrzo_bool isup;

  /*look at example 160 if you want the results to be nicely displayed*/

  /* we loop through the number of routes */
  lcrzo_er(lcrzo_conf_routes_count(&count));
  for ( i=1 ; i<=count ; i++ )
  { /*get the information*/
    lcrzo_epr(lcrzo_conf_routes_value_pos(i, device, &ipl, &mask, 
					  &source, &gw, &isup));
    /*print the information*/
    printf("\ndevice :  %s ", device);
    lcrzo_ipl_print("dest :      ", ipl, "/");
    lcrzo_ipl_print("", mask, "\n");
    lcrzo_ipl_print("source :    ", source, "\n");
    lcrzo_ipl_print("gateway :   ", gw, "\n");
    printf("isup :      %d\n", isup);
  }  

  return(LCRZO_ERR_OK);
}

