
/* include the library headers */
#include <lcrzo.h>
#include <stdlib.h>
#include <stdio.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000176=
{ /*reference*/     "lcrzoex", 176,
  /*version*/       1, 0,
  /*title*/         "get the route to a computer",
  /*french title*/  "obtient la route pour joindre une machine",
  /*description*/   "",
  /*french desc.*/  "",
  /*usage*/         "ip_address",
  /*french usage*/  "adresse_ip",
  /*usage example*/ "www.server.com",
  /*fr. usage ex.*/ "www.serveur.com",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000176_main(int argc, char *argv[]);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000176_main(int argc, char *argv[])
{ lcrzo_device device;
  lcrzo_etha srcetha, dstetha;
  lcrzo_ipl srcipl, dstipl, gwipl;
  int ret;

  if ( argc<2 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000176, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }
  lcrzo_epr(lcrzo_ipl_init_hs(argv[1], &dstipl));

  /* print the config */
  lcrzo_epr(lcrzo_conf_routes_print());
  puts("");

  /* get the necessary values to reach dstipl */
  ret=lcrzo_conf_route_to_host(dstipl,
			       device, srcetha, dstetha,
			       &srcipl, &gwipl);
  if ( ret==LCRZO_ERR_OKROUTELOCALDEV )
  { printf("The address ");
    lcrzo_ipl_print("", dstipl, "");
    printf(" is the address of the local device %s.\n", device);
  }
  else if ( ret==LCRZO_ERR_OKROUTEHOSTUNREACH )
  { printf("The address ");
    lcrzo_ipl_print("", dstipl, "");
    printf(" is on the LAN, but is temporarily unreachable.\n");
    printf("Device : %s\n", device);
    lcrzo_etha_print("Source Ethernet address : ", srcetha, "\n");
    printf("Destination Ethernet address : ???\n");
    lcrzo_ipl_print("Source IP address : ", srcipl, "\n");
    lcrzo_ipl_print("Destination IP address : ", dstipl, "\n");
  }
  else if ( ret==LCRZO_ERR_OKROUTEGWUNREACH )
  { printf("The address ");
    lcrzo_ipl_print("", dstipl, "");
    printf(" is through ");
    lcrzo_ipl_print("", gwipl, ",");
    printf(" which is temporarily unreachable.\n");
    printf("Device : %s\n", device);
    lcrzo_etha_print("Source Ethernet address : ", srcetha, "\n");
    printf("Destination Ethernet address : ???\n");
    lcrzo_ipl_print("Source IP address : ", srcipl, "\n");
    lcrzo_ipl_print("Destination IP address : ", dstipl, "\n");
  }
  else if ( ret==LCRZO_ERR_OKROUTENOTFOUND )
  { printf("No route was found to reach ");
    lcrzo_ipl_print("", dstipl, ".\n");
  }
  else if ( ret!=LCRZO_ERR_OK )
  { lcrzo_err_print(ret);
    return (LCRZO_ERR_OK);
  }
  else
  { printf("Device : %s\n", device);
    lcrzo_etha_print("Source Ethernet address : ", srcetha, "\n");
    lcrzo_etha_print("Destination Ethernet address : ", dstetha, "\n");
    lcrzo_ipl_print("Source IP address : ", srcipl, "\n");
    lcrzo_ipl_print("Destination IP address : ", dstipl, "\n");
  }

  return (LCRZO_ERR_OK);
}



